/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.user;

import com.atlassian.crowd.embedded.api.Group;
import com.atlassian.jira.security.roles.ProjectRole;
import com.atlassian.jira.security.roles.ProjectRoleManager;
import com.atlassian.jira.user.UserFilter;
import com.atlassian.jira.util.json.JSONArray;
import com.atlassian.jira.util.json.JSONException;
import com.atlassian.jira.util.json.JSONObject;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Function;
import com.google.common.base.Preconditions;
import com.google.common.base.Predicate;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.StringUtils;

public class UserFilterUtils {
    private static final String KEY_ENABLED = "enabled";
    private static final String KEY_GROUPS = "groups";
    private static final String KEY_ROLEIDS = "roleIds";
    public static final Function<ProjectRole, Long> GET_ROLE_ID_FUNCTION = new Function<ProjectRole, Long>(){

        public Long apply(ProjectRole projectRole) {
            return projectRole.getId();
        }
    };

    public static UserFilter intersectGroups(UserFilter userFilter, Set<String> groups) {
        boolean newGroupNotEmpty = CollectionUtils.isNotEmpty(groups);
        if (!userFilter.isEnabled()) {
            if (newGroupNotEmpty) {
                return new UserFilter(true, null, groups);
            }
        } else {
            Set<String> intersectedGroups = UserFilterUtils.findIntersectedGroups(userFilter.getGroups(), groups);
            if (intersectedGroups != userFilter.getGroups()) {
                return new UserFilter(true, userFilter.getRoleIds(), intersectedGroups);
            }
        }
        return userFilter;
    }

    private static Set<String> findIntersectedGroups(Set<String> groups, Set<String> newGroups) {
        return groups == null ? newGroups : (newGroups == null ? groups : Sets.intersection(groups, newGroups));
    }

    public static JSONObject toJson(UserFilter userFilter, ProjectRoleManager projectRoleManager) throws JSONException {
        Preconditions.checkNotNull((Object)userFilter, (Object)"userFilter");
        JSONObject object = new JSONObject();
        object.put(KEY_ENABLED, userFilter.isEnabled());
        if (userFilter.isEnabled()) {
            object.put(KEY_GROUPS, new JSONArray(UserFilterUtils.sortGroups(userFilter.getGroups())));
            object.put(KEY_ROLEIDS, new JSONArray(projectRoleManager != null ? UserFilterUtils.filterRemovedRoleIds(userFilter.getRoleIds(), projectRoleManager) : userFilter.getRoleIds()));
        }
        return object;
    }

    public static UserFilter fromJson(JSONObject json) throws JSONException {
        Preconditions.checkNotNull((Object)json, (Object)"json");
        boolean isEnabled = json.getBoolean(KEY_ENABLED);
        if (!isEnabled) {
            return UserFilter.DISABLED;
        }
        return new UserFilter(true, UserFilterUtils.getRoleIds(json.getJSONArray(KEY_ROLEIDS)), UserFilterUtils.getGroups(json.getJSONArray(KEY_GROUPS)));
    }

    public static UserFilter fromJsonString(String jsonString) throws JSONException {
        if (StringUtils.isEmpty((CharSequence)jsonString)) {
            return UserFilter.DISABLED;
        }
        return UserFilterUtils.fromJson(new JSONObject(jsonString));
    }

    private static Collection<Long> getRoleIds(JSONArray jsonArray) throws JSONException {
        HashSet roleIds = Sets.newHashSetWithExpectedSize((int)jsonArray.length());
        for (int i = 0; i < jsonArray.length(); ++i) {
            roleIds.add(jsonArray.getLong(i));
        }
        return roleIds;
    }

    private static Collection<String> getGroups(JSONArray jsonArray) throws JSONException {
        HashSet groups = Sets.newHashSetWithExpectedSize((int)jsonArray.length());
        for (int i = 0; i < jsonArray.length(); ++i) {
            groups.add(jsonArray.getString(i));
        }
        return groups;
    }

    public static UserFilter getFilterWithoutRemovedGroupsAndRoles(UserFilter filter, Collection<Group> allGroups, ProjectRoleManager projectRoleManager) {
        return filter != null && filter.isEnabled() ? new UserFilter(true, UserFilterUtils.filterRemovedRoleIds(filter.getRoleIds(), projectRoleManager), UserFilterUtils.filterRemovedGroups(filter.getGroups(), allGroups)) : filter;
    }

    public static Set<String> filterRemovedGroups(Set<String> groups, Collection<Group> allGroups) {
        if (CollectionUtils.isEmpty(groups)) {
            return groups;
        }
        final ImmutableSet allGroupNames = ImmutableSet.copyOf((Iterable)Iterables.transform(allGroups, (Function)new Function<Group, String>(){

            public String apply(Group input) {
                return input.getName();
            }
        }));
        return ImmutableSet.copyOf((Iterable)Iterables.filter(groups, (Predicate)new Predicate<String>(){

            public boolean apply(String input) {
                return allGroupNames.contains((Object)input);
            }
        }));
    }

    @VisibleForTesting
    static Set<Long> filterRemovedRoleIds(Set<Long> roleIds, ProjectRoleManager projectRoleManager) {
        if (CollectionUtils.isEmpty(roleIds)) {
            return roleIds;
        }
        return ImmutableSet.copyOf((Iterable)Iterables.transform(UserFilterUtils.getProjectRoles(projectRoleManager, roleIds), GET_ROLE_ID_FUNCTION));
    }

    public static List<ProjectRole> getProjectRoles(ProjectRoleManager projectRoleManager, Set<Long> roleIds) {
        List<ProjectRole> projectRoles;
        List<ProjectRole> list = projectRoles = roleIds.size() > 1 ? UserFilterUtils.getProjectRolesFromAll(projectRoleManager, roleIds) : UserFilterUtils.getProjectRolesIndividually(projectRoleManager, roleIds);
        if (projectRoles.size() > 1) {
            Collections.sort(projectRoles, new Comparator<ProjectRole>(){

                @Override
                public int compare(ProjectRole p1, ProjectRole p2) {
                    return ObjectUtils.compare((Comparable)((Object)p1.getName()), (Comparable)((Object)p2.getName()));
                }
            });
        }
        return projectRoles;
    }

    private static List<ProjectRole> getProjectRolesIndividually(ProjectRoleManager projectRoleManager, Set<Long> roleIds) {
        if (roleIds.isEmpty()) {
            return ImmutableList.of();
        }
        ProjectRole projectRole = projectRoleManager.getProjectRole(roleIds.iterator().next());
        return projectRole != null ? ImmutableList.of((Object)projectRole) : ImmutableList.of();
    }

    private static List<ProjectRole> getProjectRolesFromAll(ProjectRoleManager projectRoleManager, final Set<Long> roleIds) {
        return Lists.newArrayList((Iterable)Iterables.filter(projectRoleManager.getProjectRoles(), (Predicate)new Predicate<ProjectRole>(){

            public boolean apply(ProjectRole input) {
                return roleIds.contains(input.getId());
            }
        }));
    }

    public static List<String> sortGroups(Collection<String> groups) {
        ArrayList groupList = Lists.newArrayList(groups);
        Collections.sort(groupList);
        return groupList;
    }
}

