/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.query;

import com.atlassian.annotations.Internal;
import com.atlassian.query.Query;
import com.atlassian.query.clause.Clause;
import com.atlassian.query.order.OrderBy;
import com.atlassian.query.order.OrderByImpl;
import com.atlassian.query.order.SearchSort;

@Internal
public class QueryImpl
implements Query {
    private final Clause whereClause;
    private final OrderBy orderByClause;
    private final String queryString;

    public QueryImpl() {
        this(null, null, null);
    }

    public QueryImpl(Clause whereClause) {
        this(whereClause, new OrderByImpl(new SearchSort[0]), null);
    }

    public QueryImpl(Clause whereClause, String originalQuery) {
        this(whereClause, new OrderByImpl(new SearchSort[0]), originalQuery);
    }

    public QueryImpl(Clause whereClause, OrderBy orderByClause, String originalQuery) {
        this.whereClause = whereClause;
        this.queryString = originalQuery;
        this.orderByClause = orderByClause;
    }

    @Override
    public Clause getWhereClause() {
        return this.whereClause;
    }

    @Override
    public OrderBy getOrderByClause() {
        return this.orderByClause;
    }

    @Override
    public String getQueryString() {
        return this.queryString;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        if (this.whereClause != null) {
            builder.append(this.whereClause.toString());
        }
        if (this.orderByClause != null && !this.orderByClause.getSearchSorts().isEmpty()) {
            if (builder.length() > 0) {
                builder.append(" ");
            }
            builder.append(this.orderByClause.toString());
        }
        return builder.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        QueryImpl that = (QueryImpl)o;
        if (this.orderByClause != null ? !this.orderByClause.equals(that.orderByClause) : that.orderByClause != null) {
            return false;
        }
        if (this.queryString != null ? !this.queryString.equals(that.queryString) : that.queryString != null) {
            return false;
        }
        return !(this.whereClause != null ? !this.whereClause.equals(that.whereClause) : that.whereClause != null);
    }

    public int hashCode() {
        int result = this.whereClause != null ? this.whereClause.hashCode() : 0;
        result = 31 * result + (this.orderByClause != null ? this.orderByClause.hashCode() : 0);
        result = 31 * result + (this.queryString != null ? this.queryString.hashCode() : 0);
        return result;
    }
}

