/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.issue.statistics;

import com.atlassian.jira.issue.comparator.VersionComparator;
import com.atlassian.jira.issue.search.SearchRequest;
import com.atlassian.jira.issue.search.SearchRequestAppender;
import com.atlassian.jira.issue.search.util.SearchRequestAddendumBuilder;
import com.atlassian.jira.issue.statistics.StatisticsMapper;
import com.atlassian.jira.jql.builder.JqlClauseBuilder;
import com.atlassian.jira.project.version.Version;
import com.atlassian.jira.project.version.VersionManager;
import com.atlassian.jira.util.dbc.Assertions;
import com.atlassian.query.operator.Operator;
import java.util.Comparator;
import org.apache.commons.lang3.StringUtils;

public class VersionStatisticsMapper
implements StatisticsMapper,
SearchRequestAppender.Factory {
    private final VersionManager versionManager;
    private final String clauseName;
    private final String documentConstant;
    boolean includeArchived = false;

    public VersionStatisticsMapper(String clauseName, String documentConstant, VersionManager versionManager, boolean includeArchived) {
        this.clauseName = clauseName;
        this.documentConstant = documentConstant;
        this.versionManager = versionManager;
        this.includeArchived = includeArchived;
    }

    @Override
    public Comparator getComparator() {
        return VersionComparator.COMPARATOR;
    }

    public boolean isValidValue(Object value) {
        if (value == null) {
            return true;
        }
        if (!this.includeArchived) {
            return !((Version)value).isArchived();
        }
        return true;
    }

    @Override
    public Object getValueFromLuceneField(String documentValue) {
        long versionId;
        if (StringUtils.isNotBlank((CharSequence)documentValue) && (versionId = Long.parseLong(documentValue)) > 0L) {
            return this.versionManager.getVersion(new Long(versionId));
        }
        return null;
    }

    @Deprecated
    public SearchRequest getSearchUrlSuffix(Object version, SearchRequest searchRequest) {
        return this.getSearchRequestAppender().appendInclusiveSingleValueClause(version, searchRequest);
    }

    public SearchRequestAppender getSearchRequestAppender() {
        return new VersionSearchRequestAppender(this.getClauseName());
    }

    protected String getClauseName() {
        return this.clauseName;
    }

    @Override
    public boolean isFieldAlwaysPartOfAnIssue() {
        return true;
    }

    @Override
    public String getDocumentConstant() {
        return this.documentConstant;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        VersionStatisticsMapper that = (VersionStatisticsMapper)o;
        if (this.includeArchived != that.includeArchived) {
            return false;
        }
        return this.getDocumentConstant() != null ? this.getDocumentConstant().equals(that.getDocumentConstant()) : that.getDocumentConstant() == null;
    }

    @Override
    public int hashCode() {
        int result = this.includeArchived ? 1 : 0;
        result = 29 * result + (this.getDocumentConstant() != null ? this.getDocumentConstant().hashCode() : 0);
        return result;
    }

    static class VersionSearchRequestAppender
    implements SearchRequestAddendumBuilder.AddendumCallback<Version>,
    SearchRequestAppender<Version> {
        private final String clauseName;

        public VersionSearchRequestAppender(String clauseName) {
            this.clauseName = Assertions.notNull(clauseName);
        }

        @Override
        public void appendNonNullItem(Version version, JqlClauseBuilder clauseBuilder) {
            clauseBuilder.sub().project(version.getProjectObject().getKey()).and().addStringCondition(this.clauseName, Operator.EQUALS, version.getName()).endsub();
        }

        @Override
        public void appendNullItem(JqlClauseBuilder clauseBuilder) {
            clauseBuilder.addEmptyCondition(this.clauseName);
        }

        @Override
        public SearchRequest appendInclusiveSingleValueClause(Version version, SearchRequest searchRequest) {
            return SearchRequestAddendumBuilder.appendAndClause(version, searchRequest, this);
        }

        @Override
        public SearchRequest appendExclusiveMultiValueClause(Iterable versions, SearchRequest searchRequest) {
            return SearchRequestAddendumBuilder.appendAndNotClauses(versions, searchRequest, this);
        }
    }
}

