/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.issue.search.searchers.util;

import com.atlassian.jira.issue.search.ClauseNames;
import com.atlassian.jira.util.dbc.Assertions;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.apache.commons.lang3.builder.ToStringStyle;

public final class DateSearcherConfig {
    public static final String AFTER_SUFFIX = ":after";
    public static final String BEFORE_SUFFIX = ":before";
    public static final String NEXT_SUFFIX = ":next";
    public static final String PREVIOUS_SUFFIX = ":previous";
    public static final String EQUALS_SUFFIX = ":equals";
    private final String id;
    private final String after;
    private final String before;
    private final String next;
    private final String previous;
    private final String equals;
    private final ClauseNames clauseNames;
    private final String fieldName;

    public DateSearcherConfig(String id, ClauseNames clauseNames, String fieldName) {
        this.id = Assertions.notBlank("id", id);
        this.fieldName = Assertions.notBlank("fieldName", fieldName);
        this.clauseNames = Assertions.notNull("clauseNames", clauseNames);
        this.after = this.id + AFTER_SUFFIX;
        this.before = this.id + BEFORE_SUFFIX;
        this.next = this.id + NEXT_SUFFIX;
        this.previous = this.id + PREVIOUS_SUFFIX;
        this.equals = this.id + EQUALS_SUFFIX;
    }

    public ClauseNames getClauseNames() {
        return this.clauseNames;
    }

    public String getFieldName() {
        return this.fieldName;
    }

    public String getId() {
        return this.id;
    }

    public String[] getAbsoluteFields() {
        return new String[]{this.getAfterField(), this.getBeforeField(), this.getEqualsField()};
    }

    public String getAfterField() {
        return this.after;
    }

    public String getBeforeField() {
        return this.before;
    }

    public String[] getRelativeFields() {
        return new String[]{this.getPreviousField(), this.getNextField()};
    }

    public String getNextField() {
        return this.next;
    }

    public String getPreviousField() {
        return this.previous;
    }

    public String getEqualsField() {
        return this.equals;
    }

    public String toString() {
        return ToStringBuilder.reflectionToString((Object)this, (ToStringStyle)ToStringStyle.SHORT_PREFIX_STYLE);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        DateSearcherConfig that = (DateSearcherConfig)o;
        return this.id.equals(that.id);
    }

    public int hashCode() {
        return this.id.hashCode();
    }
}

