/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.issue.index.indexers.impl;

import com.atlassian.jira.issue.Issue;
import com.atlassian.jira.issue.fields.CustomField;
import com.atlassian.jira.issue.index.indexers.impl.AbstractCustomFieldIndexer;
import com.atlassian.jira.project.version.Version;
import com.atlassian.jira.util.dbc.Assertions;
import com.atlassian.jira.web.FieldVisibilityManager;
import java.util.Collection;
import org.apache.lucene.document.Document;
import org.apache.lucene.document.Field;
import org.apache.lucene.document.SortedSetDocValuesField;
import org.apache.lucene.document.StoredField;
import org.apache.lucene.document.StringField;
import org.apache.lucene.index.IndexableField;
import org.apache.lucene.util.BytesRef;

public class VersionCustomFieldIndexer
extends AbstractCustomFieldIndexer {
    public VersionCustomFieldIndexer(FieldVisibilityManager fieldVisibilityManager, CustomField customField) {
        super(fieldVisibilityManager, Assertions.notNull("customField", customField));
    }

    @Override
    public void addDocumentFieldsSearchable(Document doc, Issue issue) {
        this.addDocumentFields(doc, issue, true);
    }

    @Override
    public void addDocumentFieldsNotSearchable(Document doc, Issue issue) {
        this.addDocumentFields(doc, issue, false);
    }

    @Override
    public Boolean skipsIndexingNull() {
        return true;
    }

    public void addDocumentFields(Document doc, Issue issue, boolean searchable) {
        Object value = this.customField.getValue(issue);
        if (value instanceof Collection) {
            Collection versions = (Collection)value;
            for (Version version : versions) {
                if (searchable) {
                    doc.add((IndexableField)new StringField(this.getDocumentFieldId(), version.getId().toString(), Field.Store.YES));
                    doc.add((IndexableField)new SortedSetDocValuesField(this.getDocumentFieldId(), new BytesRef((CharSequence)version.getId().toString())));
                    continue;
                }
                doc.add((IndexableField)new StoredField(this.getDocumentFieldId(), version.getId().toString()));
            }
        }
    }
}

