/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.issue.customfields.searchers.transformer;

import com.atlassian.jira.issue.customfields.converters.DoubleConverter;
import com.atlassian.jira.issue.customfields.impl.FieldValidationException;
import com.atlassian.jira.issue.customfields.searchers.transformer.AbstractCustomFieldSearchInputTransformer;
import com.atlassian.jira.issue.customfields.searchers.transformer.CustomFieldInputHelper;
import com.atlassian.jira.issue.customfields.searchers.transformer.NumberRangeCustomFieldInputHelper;
import com.atlassian.jira.issue.customfields.view.CustomFieldParams;
import com.atlassian.jira.issue.customfields.view.CustomFieldParamsImpl;
import com.atlassian.jira.issue.fields.CustomField;
import com.atlassian.jira.issue.search.ClauseNames;
import com.atlassian.jira.issue.search.SearchContext;
import com.atlassian.jira.issue.search.searchers.transformer.SearchInputTransformer;
import com.atlassian.jira.issue.transport.FieldValuesHolder;
import com.atlassian.jira.jql.operand.JqlOperandResolver;
import com.atlassian.jira.jql.operand.QueryLiteral;
import com.atlassian.jira.user.ApplicationUser;
import com.atlassian.jira.util.ErrorCollection;
import com.atlassian.jira.util.I18nHelper;
import com.atlassian.query.Query;
import com.atlassian.query.clause.AndClause;
import com.atlassian.query.clause.Clause;
import com.atlassian.query.clause.TerminalClause;
import com.atlassian.query.clause.TerminalClauseImpl;
import com.atlassian.query.operator.Operator;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Set;
import org.apache.commons.lang3.StringUtils;

public class NumberRangeCustomFieldSearchInputTransformer
extends AbstractCustomFieldSearchInputTransformer
implements SearchInputTransformer {
    private final ClauseNames clauseNames;
    private final DoubleConverter doubleConverter;
    private final JqlOperandResolver jqlOperandResolver;
    private final NumberRangeCustomFieldInputHelper inputHelper;

    public NumberRangeCustomFieldSearchInputTransformer(ClauseNames clauseNames, CustomField field, String urlParameterName, DoubleConverter doubleConverter, JqlOperandResolver jqlOperandResolver, CustomFieldInputHelper customFieldInputHelper) {
        super(field, urlParameterName, customFieldInputHelper);
        this.clauseNames = clauseNames;
        this.doubleConverter = doubleConverter;
        this.jqlOperandResolver = jqlOperandResolver;
        this.inputHelper = this.createInputHelper(clauseNames, jqlOperandResolver);
    }

    @Override
    public void validateParams(ApplicationUser user, SearchContext searchContext, FieldValuesHolder fieldValuesHolder, I18nHelper i18nHelper, ErrorCollection errors) {
        CustomFieldParams params = (CustomFieldParams)fieldValuesHolder.get(this.getCustomField().getId());
        if (params != null) {
            String[] rangeParams;
            for (String rangeParam : rangeParams = new String[]{"lessThan", "greaterThan"}) {
                String numberString = (String)params.getFirstValueForKey(rangeParam);
                if (!StringUtils.isNotEmpty((CharSequence)numberString)) continue;
                try {
                    this.doubleConverter.getDouble(numberString);
                }
                catch (FieldValidationException e) {
                    errors.addError(this.getCustomField().getId(), e.getMessage());
                }
            }
        }
    }

    @Override
    protected Clause getClauseFromParams(ApplicationUser user, CustomFieldParams customFieldParams) {
        String s;
        ArrayList<TerminalClauseImpl> clauses = new ArrayList<TerminalClauseImpl>();
        String clauseName = this.getClauseName(user, this.clauseNames);
        if (customFieldParams.containsKey("lessThan") && (s = (String)customFieldParams.getFirstValueForKey("lessThan")) != null) {
            clauses.add(new TerminalClauseImpl(clauseName, Operator.LESS_THAN_EQUALS, s));
        }
        if (customFieldParams.containsKey("greaterThan") && (s = (String)customFieldParams.getFirstValueForKey("greaterThan")) != null) {
            clauses.add(new TerminalClauseImpl(clauseName, Operator.GREATER_THAN_EQUALS, s));
        }
        if (clauses.isEmpty()) {
            return null;
        }
        if (clauses.size() == 1) {
            return (Clause)clauses.get(0);
        }
        return new AndClause(clauses);
    }

    @Override
    protected CustomFieldParams getParamsFromSearchRequest(ApplicationUser user, Query query, SearchContext searchContext) {
        List<TerminalClause> clauses;
        if (query != null && query.getWhereClause() != null && (clauses = this.inputHelper.getValuesFromQuery(query)) != null && !clauses.isEmpty()) {
            HashMap<String, Set<String>> params = new HashMap<String, Set<String>>();
            for (TerminalClause clause : clauses) {
                List<QueryLiteral> values = this.jqlOperandResolver.getValues(user, clause.getOperand(), clause);
                if (values == null || values.size() != 1 || values.get(0).isEmpty()) {
                    return null;
                }
                String value = values.get(0).asString();
                if (clause.getOperator() == Operator.GREATER_THAN_EQUALS) {
                    params.put("greaterThan", Collections.singleton(value));
                    continue;
                }
                if (clause.getOperator() == Operator.LESS_THAN_EQUALS) {
                    params.put("lessThan", Collections.singleton(value));
                    continue;
                }
                throw new IllegalStateException("Invalid operator in retreiving params from search request");
            }
            return new CustomFieldParamsImpl(this.getCustomField(), params);
        }
        return null;
    }

    @Override
    public boolean doRelevantClausesFitFilterForm(ApplicationUser user, Query query, SearchContext searchContext) {
        return query.getWhereClause() == null || this.inputHelper.getValuesFromQuery(query) != null;
    }

    NumberRangeCustomFieldInputHelper createInputHelper(ClauseNames clauseNames, JqlOperandResolver jqlOperandResolver) {
        return new NumberRangeCustomFieldInputHelper(clauseNames, jqlOperandResolver);
    }
}

