/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.database;

import com.google.common.collect.ImmutableMap;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.lang.StringEscapeUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.math.NumberUtils;

public enum DatabaseVendor {
    POSTGRES("Postgres"){

        @Override
        public String getVersion(String version) {
            return DatabaseVendor.getPostgresDatabaseVersion(version);
        }
    }
    ,
    ORACLE("Oracle"){

        @Override
        public String getVersion(String version) {
            return DatabaseVendor.getOracleDatabaseVersion(version);
        }
    }
    ,
    SQL_SERVER("SQL Server"){

        @Override
        public String getVersion(String version) {
            return DatabaseVendor.getSQLServerVersion(version);
        }
    }
    ,
    H2("H2"),
    MY_SQL("MySQL"),
    FAKE_DATABASE_FOR_TESTING("fakedatabase");

    final String humanReadableName;
    private static final Pattern VERSION_PATTERN;
    private static final Pattern ORACLE_MAJOR_MINOR_PATTERN;
    private static final Map<String, String> ORACLE_VERSION_ALIASES;
    private static final Map<String, String> MSSQL_VERSION_ALIASES;

    public String getHumanReadableName() {
        return this.humanReadableName;
    }

    private DatabaseVendor(String humanReadableName) {
        this.humanReadableName = humanReadableName;
    }

    private static String getOracleDatabaseVersion(String version) {
        Matcher m = ORACLE_MAJOR_MINOR_PATTERN.matcher(version);
        if (!m.matches()) {
            throw new IllegalArgumentException("the version string retrieved from the database does not seem to contain a version number (version string: \"" + StringEscapeUtils.escapeJava((String)version) + "\")");
        }
        return ORACLE_VERSION_ALIASES.entrySet().stream().filter(entry -> m.group(1).equals(entry.getKey())).map(Map.Entry::getValue).findFirst().orElseThrow(() -> new IllegalArgumentException("the version number retrieved from the database isn't a known version of Oracle Database (version string: \"" + StringEscapeUtils.escapeJava((String)version) + "\")"));
    }

    private static String getSQLServerVersion(String version) {
        return MSSQL_VERSION_ALIASES.entrySet().stream().filter(entry -> version.matches((String)entry.getKey())).map(Map.Entry::getValue).findFirst().orElseThrow(() -> new IllegalArgumentException("the version number retrieved from the database isn't a known version of SQL Server (version string: \"" + StringEscapeUtils.escapeJava((String)version) + "\")"));
    }

    private static String getPostgresDatabaseVersion(String version) {
        int major;
        Matcher matcher = VERSION_PATTERN.matcher(version);
        if (!matcher.matches()) {
            throw new IllegalArgumentException("the version string retrieved from the database isn't a version number (version string: \"" + StringEscapeUtils.escapeJava((String)version) + "\")");
        }
        String[] parts = StringUtils.split((String)matcher.group(1), (String)".");
        int n = major = parts.length > 0 ? NumberUtils.toInt((String)parts[0]) : 0;
        if (major < 10) {
            int minor = parts.length > 1 ? NumberUtils.toInt((String)parts[1]) : 0;
            return major + "." + minor;
        }
        return String.valueOf(major);
    }

    @Deprecated
    public static String getSQLServerVersionIfExists(String version) {
        try {
            return DatabaseVendor.getSQLServerVersion(version);
        }
        catch (IllegalArgumentException e) {
            return version;
        }
    }

    public String getVersion(String version) {
        Matcher matcher = VERSION_PATTERN.matcher(version);
        if (matcher.matches()) {
            String[] parts = StringUtils.split((String)matcher.group(1), (String)".");
            int major = parts.length > 0 ? NumberUtils.toInt((String)parts[0]) : 0;
            int minor = parts.length > 1 ? NumberUtils.toInt((String)parts[1]) : 0;
            return major + "." + minor;
        }
        throw new IllegalArgumentException("the version number retrieved from the database isn't a version number we expected to get (major.minor.micro) (version string: \"" + StringEscapeUtils.escapeJava((String)version) + "\")");
    }

    public String getHumanReadableVersion(String version) {
        try {
            return this.getVersion(version);
        }
        catch (IllegalArgumentException e) {
            return version;
        }
    }

    static {
        VERSION_PATTERN = Pattern.compile("(\\d+(\\.\\d+)*).*");
        ORACLE_MAJOR_MINOR_PATTERN = Pattern.compile("^.*?(\\d+\\.\\d+)\\.\\d+\\.\\d+.*?", 32);
        ORACLE_VERSION_ALIASES = ImmutableMap.builder().put((Object)"19.0", (Object)"19C").put((Object)"18.0", (Object)"18C").put((Object)"12.2", (Object)"12C R2").put((Object)"12.1", (Object)"12C R1").put((Object)"11.2", (Object)"11G R2").put((Object)"11.1", (Object)"11G R1").build();
        MSSQL_VERSION_ALIASES = ImmutableMap.builder().put((Object)"14.*", (Object)"2017").put((Object)"13.*", (Object)"2016").put((Object)"12.*", (Object)"2014").put((Object)"11.*", (Object)"2012").put((Object)"10.5.+", (Object)"2008 R2").put((Object)"10.[0-4].*", (Object)"2008").put((Object)"9.*", (Object)"2005").put((Object)"8.*", (Object)"2000").build();
    }
}

