/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.config.managedconfiguration;

import com.atlassian.annotations.PublicApi;
import com.atlassian.jira.config.managedconfiguration.ConfigurationItemAccessLevel;
import com.atlassian.jira.config.managedconfiguration.ManagedConfigurationItem;
import com.atlassian.jira.config.managedconfiguration.ManagedConfigurationItemType;
import com.atlassian.plugin.Plugin;

@PublicApi
public class ManagedConfigurationItemBuilder {
    private Long id;
    private String itemId;
    private ManagedConfigurationItemType itemType;
    private boolean isManaged;
    private ConfigurationItemAccessLevel configurationItemAccessLevel;
    private String source;
    private String descriptionI18nKey;

    public static ManagedConfigurationItemBuilder builder(ManagedConfigurationItem source) {
        return new ManagedConfigurationItemBuilder().setId(source.getId()).setItemId(source.getItemId()).setItemType(source.getItemType()).setManaged(source.isManaged()).setConfigurationItemAccessLevel(source.getConfigurationItemAccessLevel()).setSource(source.getSourceId()).setDescriptionI18nKey(source.getDescriptionI18nKey());
    }

    public ManagedConfigurationItemBuilder setId(Long id) {
        this.id = id;
        return this;
    }

    public ManagedConfigurationItemBuilder setItemId(String itemId) {
        this.itemId = itemId;
        return this;
    }

    public ManagedConfigurationItemBuilder setItemType(ManagedConfigurationItemType itemType) {
        this.itemType = itemType;
        return this;
    }

    public ManagedConfigurationItemBuilder setManaged(boolean managed) {
        this.isManaged = managed;
        return this;
    }

    public ManagedConfigurationItemBuilder setConfigurationItemAccessLevel(ConfigurationItemAccessLevel configurationItemAccessLevel) {
        this.configurationItemAccessLevel = configurationItemAccessLevel;
        return this;
    }

    public ManagedConfigurationItemBuilder setSource(Plugin plugin) {
        return this.setSource("plugin:" + plugin.getKey());
    }

    public ManagedConfigurationItemBuilder setSource(String source) {
        this.source = source;
        return this;
    }

    public ManagedConfigurationItemBuilder setDescriptionI18nKey(String descriptionI18nKey) {
        this.descriptionI18nKey = descriptionI18nKey;
        return this;
    }

    public ManagedConfigurationItem build() {
        ConfigurationItemAccessLevel accessLevel = this.configurationItemAccessLevel == null ? ConfigurationItemAccessLevel.ADMIN : this.configurationItemAccessLevel;
        return new ManagedConfigurationItem(this.id, this.itemId, this.itemType, this.isManaged, accessLevel, this.source, this.descriptionI18nKey);
    }
}

