/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.user.anonymize;

import com.atlassian.annotations.ExperimentalApi;
import com.atlassian.jira.user.ApplicationUser;
import java.io.Serializable;
import java.util.Objects;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

@ExperimentalApi
public class AnonymizationParameters
implements Serializable {
    private final String userKey;
    private final boolean rerunPluginPoints;
    private final String oldUserKey;
    private final String oldUserName;
    private final String newOwnerKey;
    private final boolean getAffectedEntities;
    private final transient ApplicationUser executor;

    private AnonymizationParameters(@Nonnull String userKey, boolean rerunPluginPoints, @Nullable String oldUserKey, @Nullable String oldUserName, @Nullable String newOwnerKey, boolean getAffectedEntities, @Nonnull ApplicationUser executor) {
        this.userKey = Objects.requireNonNull(userKey);
        this.rerunPluginPoints = rerunPluginPoints;
        this.oldUserKey = oldUserKey;
        this.oldUserName = oldUserName;
        this.newOwnerKey = newOwnerKey;
        this.getAffectedEntities = getAffectedEntities;
        this.executor = Objects.requireNonNull(executor);
    }

    public static Builder builder() {
        return new Builder();
    }

    @Nonnull
    public String getUserKey() {
        return this.userKey;
    }

    public boolean isRerunPluginPoints() {
        return this.rerunPluginPoints;
    }

    @Nullable
    public String getNewOwnerKey() {
        return this.newOwnerKey;
    }

    @Nonnull
    public ApplicationUser getExecutor() {
        return this.executor;
    }

    @Nullable
    public String getOldUserKey() {
        return this.oldUserKey;
    }

    @Nullable
    public String getOldUserName() {
        return this.oldUserName;
    }

    public boolean isGetAffectedEntities() {
        return this.getAffectedEntities;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        AnonymizationParameters that = (AnonymizationParameters)o;
        return this.rerunPluginPoints == that.rerunPluginPoints && this.getAffectedEntities == that.getAffectedEntities && Objects.equals(this.userKey, that.userKey) && Objects.equals(this.oldUserKey, that.oldUserKey) && Objects.equals(this.oldUserName, that.oldUserName) && Objects.equals(this.newOwnerKey, that.newOwnerKey) && Objects.equals(this.executor, that.executor);
    }

    public int hashCode() {
        return Objects.hash(this.userKey, this.rerunPluginPoints, this.oldUserKey, this.oldUserName, this.newOwnerKey, this.getAffectedEntities, this.executor);
    }

    public String toString() {
        return "AnonymizationParameters{userKey='" + this.userKey + '\'' + ", rerunPluginPoints=" + this.rerunPluginPoints + ", oldUserKey='" + this.oldUserKey + '\'' + ", oldUserName='" + this.oldUserName + '\'' + ", newOwnerKey='" + this.newOwnerKey + '\'' + ", getAffectedEntities=" + this.getAffectedEntities + ", executor=" + this.executor + '}';
    }

    public static class Builder {
        private String userKey;
        private boolean rerunPluginPoints;
        private String oldUserKey;
        private String oldUserName;
        private String newOwnerKey;
        private boolean getAffectedEntities;
        private ApplicationUser executor;

        public Builder targetUser(@Nonnull String userKey) {
            this.userKey = Objects.requireNonNull(userKey);
            return this;
        }

        public Builder rerunPluginPoints(boolean rerunPluginPoints) {
            this.rerunPluginPoints = rerunPluginPoints;
            return this;
        }

        public Builder newOwnerKey(@Nullable String newOwnerKey) {
            this.newOwnerKey = newOwnerKey;
            return this;
        }

        public Builder executor(@Nonnull ApplicationUser executor) {
            this.executor = Objects.requireNonNull(executor);
            return this;
        }

        public Builder oldUserKey(@Nullable String oldUserKey) {
            this.oldUserKey = oldUserKey;
            return this;
        }

        public Builder oldUserName(@Nullable String oldUserName) {
            this.oldUserName = oldUserName;
            return this;
        }

        public Builder getAffectedEntities(boolean getAffectedEntities) {
            this.getAffectedEntities = getAffectedEntities;
            return this;
        }

        public AnonymizationParameters build() {
            return new AnonymizationParameters(this.userKey, this.rerunPluginPoints, this.oldUserKey, this.oldUserName, this.newOwnerKey, this.getAffectedEntities, this.executor);
        }
    }
}

