/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.plugin.report.impl;

import com.atlassian.annotations.PublicSpi;
import com.atlassian.jira.component.ComponentAccessor;
import com.atlassian.jira.issue.IssueConstant;
import com.atlassian.jira.plugin.report.Report;
import com.atlassian.jira.plugin.report.ReportModuleDescriptor;
import com.atlassian.jira.web.action.ProjectActionSupport;
import java.util.Map;
import org.ofbiz.core.entity.GenericValue;

@PublicSpi
public abstract class AbstractReport
implements Report {
    protected ReportModuleDescriptor descriptor;

    @Override
    public void init(ReportModuleDescriptor descriptor) {
        this.descriptor = descriptor;
    }

    @Override
    public void validate(ProjectActionSupport action, Map params) {
    }

    @Override
    public boolean isExcelViewSupported() {
        return false;
    }

    @Override
    public String generateReportExcel(ProjectActionSupport action, Map params) throws Exception {
        throw new UnsupportedOperationException("This report does not support an Excel view.");
    }

    @Override
    public boolean showReport() {
        return true;
    }

    protected ReportModuleDescriptor getDescriptor() {
        return this.descriptor;
    }

    public IssueConstant getIssueConstant(GenericValue issueConstantGV) {
        return ComponentAccessor.getConstantsManager().getIssueConstant(issueConstantGV);
    }

    public static class MutableLong
    extends Number {
        private long value;

        public MutableLong(long initialValue) {
            this.value = initialValue;
        }

        public long incrementAndGet() {
            return ++this.value;
        }

        public long getAndIncrement() {
            return this.value++;
        }

        public long add(long adjustment) {
            return this.value += adjustment;
        }

        public void setValue(long newValue) {
            this.value = newValue;
        }

        @Override
        public int intValue() {
            return (int)this.value;
        }

        @Override
        public long longValue() {
            return this.value;
        }

        @Override
        public float floatValue() {
            return this.value;
        }

        @Override
        public double doubleValue() {
            return this.value;
        }

        public boolean equals(Object o) {
            return o instanceof MutableLong && this.value == ((MutableLong)o).value;
        }

        public int hashCode() {
            return (int)(this.value ^ this.value >>> 32);
        }

        public String toString() {
            return String.valueOf(this.value);
        }
    }
}

