/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.jql.validator;

import com.atlassian.jira.component.ComponentAccessor;
import com.atlassian.jira.jql.operand.JqlOperandResolver;
import com.atlassian.jira.jql.operand.QueryLiteral;
import com.atlassian.jira.jql.util.JqlLocalDateSupport;
import com.atlassian.jira.user.ApplicationUser;
import com.atlassian.jira.util.I18nHelper;
import com.atlassian.jira.util.MessageSet;
import com.atlassian.jira.util.MessageSetImpl;
import com.atlassian.jira.util.dbc.Assertions;
import com.atlassian.query.clause.TerminalClause;
import com.atlassian.query.operand.Operand;
import java.util.List;

class LocalDateValueValidator {
    private final JqlOperandResolver operandResolver;
    private final JqlLocalDateSupport localDateSupport;

    LocalDateValueValidator(JqlOperandResolver operandResolver, JqlLocalDateSupport support) {
        this.operandResolver = Assertions.notNull("operandResolver", operandResolver);
        this.localDateSupport = Assertions.notNull("support", support);
    }

    MessageSet validate(ApplicationUser searcher, TerminalClause terminalClause) {
        Assertions.notNull("terminalClause", terminalClause);
        Operand operand = terminalClause.getOperand();
        MessageSetImpl messages = new MessageSetImpl();
        if (this.operandResolver.isValidOperand(operand)) {
            I18nHelper i18n = this.getI18n(searcher);
            List<QueryLiteral> values = this.operandResolver.getValues(searcher, operand, terminalClause);
            String fieldName = terminalClause.getName();
            for (QueryLiteral value : values) {
                boolean result;
                String str = value.getStringValue();
                if (str == null || (result = this.localDateSupport.validate(str))) continue;
                String msg = this.operandResolver.isFunctionOperand(value.getSourceOperand()) ? i18n.getText("jira.jql.clause.local.date.format.invalid.from.func", fieldName, value.getSourceOperand().getName()) : i18n.getText("jira.jql.clause.local.date.format.invalid", str, fieldName);
                messages.addErrorMessage(msg);
            }
        }
        return messages;
    }

    I18nHelper getI18n(ApplicationUser user) {
        return ComponentAccessor.getComponent(I18nHelper.BeanFactory.class).getInstance(user);
    }
}

