/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.issue.context;

import com.atlassian.annotations.Internal;
import com.atlassian.jira.issue.comparator.ProjectNameComparator;
import com.atlassian.jira.issue.context.IssueContext;
import com.atlassian.jira.issue.context.JiraContextNode;
import com.atlassian.jira.issue.issuetype.IssueType;
import com.atlassian.jira.project.Project;
import org.apache.commons.lang3.builder.CompareToBuilder;
import org.apache.commons.lang3.builder.EqualsBuilder;
import org.apache.commons.lang3.builder.HashCodeBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Internal
public abstract class AbstractJiraContext
implements JiraContextNode {
    private static final Logger log = LoggerFactory.getLogger(AbstractJiraContext.class);

    @Override
    public boolean isInContext(IssueContext issueContext) {
        boolean matches = true;
        if (issueContext != null) {
            if (this.getProjectId() != null) {
                matches = this.getProjectId().equals(issueContext.getProjectId());
            }
            if (this.getIssueTypeId() != null) {
                matches &= this.getIssueTypeId().equals(issueContext.getIssueTypeId());
            }
        } else {
            log.warn("The issue passed is null. Returning as a context match");
        }
        return matches;
    }

    public String toString() {
        IssueType issueType;
        StringBuilder sb = new StringBuilder();
        Project project = this.getProjectObject();
        if (project != null) {
            sb.append("Project: ").append(project.getName());
        }
        if ((issueType = this.getIssueTypeObject()) != null) {
            if (sb.length() > 0) {
                sb.append(", ");
            }
            sb.append("Issue type: ").append(issueType.getName());
        }
        String description = sb.length() > 0 ? sb.toString() : "Global Context";
        return this.getClass().getSimpleName() + "[" + description + "]";
    }

    @Override
    public int compareTo(JiraContextNode o) {
        return new CompareToBuilder().append((Object)this.getProjectObject(), (Object)o.getProjectObject(), ProjectNameComparator.COMPARATOR).toComparison();
    }

    public boolean equals(Object o) {
        if (!(o instanceof JiraContextNode)) {
            return false;
        }
        JiraContextNode rhs = (JiraContextNode)o;
        return new EqualsBuilder().append((Object)this.getProjectId(), (Object)rhs.getProjectId()).isEquals();
    }

    public int hashCode() {
        return new HashCodeBuilder(77, 127).append((Object)this.getProjectId()).toHashCode();
    }
}

