/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.project;

import com.atlassian.annotations.PublicApi;
import com.atlassian.jira.project.AssigneeTypes;
import com.atlassian.jira.util.collect.MapBuilder;
import java.util.Map;

@PublicApi
public class ProjectAssigneeTypes
extends AssigneeTypes {
    private static final String NO_DEFAULT_MESSAGE = "Please select a Default Assignee";

    public static boolean isValidType(Long defaultAssigneeType) {
        return defaultAssigneeType != null && (defaultAssigneeType == 2L || defaultAssigneeType == 3L && ProjectAssigneeTypes.isAllowUnassigned());
    }

    public static boolean isProjectLead(Long defaultAssigneeType) {
        if (defaultAssigneeType == null) {
            return !ProjectAssigneeTypes.isAllowUnassigned();
        }
        return defaultAssigneeType == 2L;
    }

    public static boolean isUnassigned(Long defaultAssigneeType) {
        if (defaultAssigneeType == null) {
            return ProjectAssigneeTypes.isAllowUnassigned();
        }
        return defaultAssigneeType == 3L;
    }

    public static Map<String, String> getAssigneeTypes() {
        if (ProjectAssigneeTypes.isAllowUnassigned()) {
            return MapBuilder.build(String.valueOf(3L), "admin.assignee.type.unassigned", String.valueOf(2L), "admin.assignee.type.project.lead");
        }
        return MapBuilder.build(String.valueOf(2L), "admin.assignee.type.project.lead");
    }

    public static String getPrettyAssigneeType(Long defaultAssigneeType) {
        if (ProjectAssigneeTypes.isProjectLead(defaultAssigneeType)) {
            return "admin.assignee.type.project.lead";
        }
        if (ProjectAssigneeTypes.isUnassigned(defaultAssigneeType)) {
            return "admin.assignee.type.unassigned";
        }
        return NO_DEFAULT_MESSAGE;
    }
}

