/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.permission;

import com.atlassian.annotations.ExperimentalApi;
import com.atlassian.annotations.Internal;
import com.atlassian.jira.permission.GlobalPermissionKey;
import com.atlassian.jira.security.Permissions;
import com.google.common.collect.BiMap;
import com.google.common.collect.ImmutableBiMap;
import com.google.common.collect.ImmutableSortedSet;
import java.util.Set;

@ExperimentalApi
public final class GlobalPermissionType {
    @Internal
    public static final String ADMINISTER = "ADMINISTER";
    @Internal
    public static final String SYSTEM_ADMIN = "SYSTEM_ADMIN";
    @Internal
    public static final String USE = "USE";
    @Internal
    public static final String USER_PICKER = "USER_PICKER";
    @Internal
    public static final String CREATE_SHARED_OBJECTS = "CREATE_SHARED_OBJECTS";
    @Internal
    public static final String MANAGE_GROUP_FILTER_SUBSCRIPTIONS = "MANAGE_GROUP_FILTER_SUBSCRIPTIONS";
    @Internal
    public static final String BULK_CHANGE = "BULK_CHANGE";
    @Internal
    public static BiMap<Integer, String> GLOBAL_PERMISSION_ID_TRANSLATION = ImmutableBiMap.builder().put((Object)0, (Object)"ADMINISTER").put((Object)1, (Object)"USE").put((Object)44, (Object)"SYSTEM_ADMIN").put((Object)22, (Object)"CREATE_SHARED_OBJECTS").put((Object)24, (Object)"MANAGE_GROUP_FILTER_SUBSCRIPTIONS").put((Object)33, (Object)"BULK_CHANGE").put((Object)27, (Object)"USER_PICKER").build();
    private static final Set<String> USE_PERMISSIONS = ImmutableSortedSet.of((Comparable)((Object)"ADMINISTER"), (Comparable)((Object)"SYSTEM_ADMIN"), (Comparable)((Object)"USE"));
    private final String key;
    private final GlobalPermissionKey globalPermissionKey;
    private final String nameI18nKey;
    private final String descriptionI18nKey;
    private final boolean anonymousAllowed;

    @Deprecated
    @Internal
    public static Set<String> getUsePermissions() {
        return USE_PERMISSIONS;
    }

    @Internal
    public GlobalPermissionType(String key, String nameI18nKey, String descriptionI18nKey, boolean anonymousAllowed) {
        this.key = key;
        this.globalPermissionKey = GlobalPermissionKey.of(key);
        this.nameI18nKey = nameI18nKey;
        this.descriptionI18nKey = descriptionI18nKey;
        this.anonymousAllowed = anonymousAllowed;
    }

    @Internal
    public GlobalPermissionType(Permissions.Permission permission, boolean anonymousAllowed) {
        this.key = permission.name();
        this.globalPermissionKey = GlobalPermissionKey.of(this.key);
        this.nameI18nKey = permission.getNameKey();
        this.descriptionI18nKey = permission.getDescriptionKey();
        this.anonymousAllowed = anonymousAllowed;
    }

    public String getKey() {
        return this.key;
    }

    public GlobalPermissionKey getGlobalPermissionKey() {
        return this.globalPermissionKey;
    }

    public String getNameI18nKey() {
        return this.nameI18nKey;
    }

    public String getDescriptionI18nKey() {
        return this.descriptionI18nKey;
    }

    public boolean isAnonymousAllowed() {
        return this.anonymousAllowed;
    }
}

