/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.jql.context;

import com.atlassian.jira.jql.context.AllIssueTypesContext;
import com.atlassian.jira.jql.context.AllProjectsContext;
import com.atlassian.jira.jql.context.ClauseContext;
import com.atlassian.jira.jql.context.ClauseContextImpl;
import com.atlassian.jira.jql.context.IssueTypeContext;
import com.atlassian.jira.jql.context.ProjectContext;
import com.atlassian.jira.jql.context.ProjectIssueTypeContext;
import com.atlassian.jira.jql.context.ProjectIssueTypeContextImpl;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import javax.annotation.Nonnull;

public class ContextProjectMap {
    final Map<ProjectContext, Set<IssueTypeContext>> issueTypeContextsPerProject = Maps.newHashMap();
    final Set<IssueTypeContext> issueTypeContextsContainedInGlobalProjectContexts = Sets.newHashSet();
    final Set<ProjectContext> projectsWithAllIssueTypes = Sets.newHashSet();
    final boolean containsGlobalContext;

    @Nonnull
    public ContextProjectMap(@Nonnull ClauseContext context) {
        Set<ProjectIssueTypeContext> projectIssueTypeContexts = context.getContexts();
        this.containsGlobalContext = context.containsGlobalContext();
        if (projectIssueTypeContexts != null) {
            for (ProjectIssueTypeContext projectIssueTypeContext : projectIssueTypeContexts) {
                ProjectContext projectContext = projectIssueTypeContext.getProjectContext();
                IssueTypeContext issueTypeContext = projectIssueTypeContext.getIssueTypeContext();
                if (projectContext.isAll()) {
                    if (!issueTypeContext.isAll()) {
                        this.issueTypeContextsContainedInGlobalProjectContexts.add(issueTypeContext);
                    }
                } else if (issueTypeContext.isAll()) {
                    this.projectsWithAllIssueTypes.add(projectContext);
                }
                if (this.issueTypeContextsPerProject.containsKey(projectContext)) {
                    this.issueTypeContextsPerProject.get(projectContext).add(issueTypeContext);
                    continue;
                }
                HashSet issueTypeContexts = Sets.newHashSet((Object[])new IssueTypeContext[]{issueTypeContext});
                this.issueTypeContextsPerProject.put(projectContext, issueTypeContexts);
            }
        }
    }

    @Nonnull
    public ClauseContext intersect(@Nonnull ContextProjectMap contextProjectMap) {
        Set<ProjectIssueTypeContext> intersection = this.toProjectIssueTypeContextSet(this.combineContextMaps(this.issueTypeContextsPerProject, contextProjectMap.issueTypeContextsPerProject, CombineType.INTERSECT));
        Set<ProjectIssueTypeContext> explicitProjectIssueTypeContexts = this.handleGlobals(contextProjectMap);
        intersection.addAll(explicitProjectIssueTypeContexts);
        return new ClauseContextImpl(intersection);
    }

    @Nonnull
    public ClauseContext union(@Nonnull ContextProjectMap contextProjectMap) {
        Set<ProjectIssueTypeContext> union = this.toProjectIssueTypeContextSet(this.combineContextMaps(this.issueTypeContextsPerProject, contextProjectMap.issueTypeContextsPerProject, CombineType.UNION));
        return new ClauseContextImpl(union);
    }

    @Nonnull
    private Map<ProjectContext, Set<IssueTypeContext>> combineContextMaps(@Nonnull Map<ProjectContext, Set<IssueTypeContext>> map1, @Nonnull Map<ProjectContext, Set<IssueTypeContext>> map2, CombineType combineType) {
        HashSet projectContexts = Sets.newHashSet(map1.keySet());
        projectContexts.addAll(map2.keySet());
        HashMap results = Maps.newHashMap();
        for (ProjectContext projectContext : projectContexts) {
            HashSet issueTypesContextSet1 = map1.get(projectContext) == null ? Sets.newHashSet() : map1.get(projectContext);
            HashSet issueTypesContextSet2 = map2.get(projectContext) == null ? Sets.newHashSet() : map2.get(projectContext);
            HashSet resultSet = Sets.newHashSet();
            if (combineType.equals((Object)CombineType.UNION)) {
                resultSet = Sets.union((Set)issueTypesContextSet1, (Set)issueTypesContextSet2);
            } else if (combineType.equals((Object)CombineType.INTERSECT)) {
                resultSet = Sets.intersection((Set)issueTypesContextSet1, (Set)issueTypesContextSet2);
            }
            if (resultSet.isEmpty()) continue;
            results.put(projectContext, resultSet);
        }
        return results;
    }

    @Nonnull
    private Set<ProjectIssueTypeContext> handleGlobals(@Nonnull ContextProjectMap contextProjectMap) {
        HashSet projectIssueTypeContexts = Sets.newHashSet();
        if (this.containsGlobalContext) {
            projectIssueTypeContexts.addAll(this.toProjectIssueTypeContextSet(contextProjectMap.issueTypeContextsPerProject));
        }
        if (contextProjectMap.containsGlobalContext) {
            projectIssueTypeContexts.addAll(this.toProjectIssueTypeContextSet(this.issueTypeContextsPerProject));
        }
        projectIssueTypeContexts.addAll(this.getProjectIssueTypeContextsForProjectGlobals(this.projectsWithAllIssueTypes, contextProjectMap.issueTypeContextsPerProject));
        projectIssueTypeContexts.addAll(this.getProjectIssueTypeContextsForProjectGlobals(contextProjectMap.projectsWithAllIssueTypes, this.issueTypeContextsPerProject));
        projectIssueTypeContexts.addAll(this.getProjectIssueTypeContextsForAllIssueTypes(this.issueTypeContextsContainedInGlobalProjectContexts, contextProjectMap.issueTypeContextsPerProject));
        projectIssueTypeContexts.addAll(this.getProjectIssueTypeContextsForAllIssueTypes(contextProjectMap.issueTypeContextsContainedInGlobalProjectContexts, this.issueTypeContextsPerProject));
        return projectIssueTypeContexts;
    }

    @Nonnull
    private Set<ProjectIssueTypeContext> getProjectIssueTypeContextsForProjectGlobals(@Nonnull Set<ProjectContext> projectsWithAllIssueTypes, @Nonnull Map<ProjectContext, Set<IssueTypeContext>> issueTypeContextsMap) {
        HashSet projectIssueTypeContexts = Sets.newHashSet();
        for (ProjectContext projectContext : projectsWithAllIssueTypes) {
            Set<IssueTypeContext> issueTypeContexts = issueTypeContextsMap.get(projectContext);
            Set<IssueTypeContext> issueTypeContextsinAllProjectContexts = issueTypeContextsMap.get(AllProjectsContext.INSTANCE);
            if (issueTypeContexts != null) {
                projectIssueTypeContexts.addAll(this.toProjectIssueTypeContextSet(projectContext, issueTypeContexts));
            }
            if (issueTypeContextsinAllProjectContexts == null) continue;
            projectIssueTypeContexts.addAll(this.toProjectIssueTypeContextSet(projectContext, issueTypeContextsinAllProjectContexts));
        }
        return projectIssueTypeContexts;
    }

    @Nonnull
    private Set<ProjectIssueTypeContext> toProjectIssueTypeContextSet(@Nonnull ProjectContext projectContext, @Nonnull Set<IssueTypeContext> issueTypeContexts) {
        HashSet projectIssueTypeContexts = Sets.newHashSet();
        for (IssueTypeContext issueTypeContext : issueTypeContexts) {
            if (issueTypeContext == AllIssueTypesContext.INSTANCE) continue;
            projectIssueTypeContexts.add(new ProjectIssueTypeContextImpl(projectContext, issueTypeContext));
        }
        return projectIssueTypeContexts;
    }

    @Nonnull
    private Set<ProjectIssueTypeContext> getProjectIssueTypeContextsForAllIssueTypes(@Nonnull Set<IssueTypeContext> issueTypeContextsInAllProjects, @Nonnull Map<ProjectContext, Set<IssueTypeContext>> issueTypeContextsMap) {
        HashSet projectIssueTypeContexts = Sets.newHashSet();
        if (issueTypeContextsInAllProjects.size() > 0) {
            for (ProjectContext projectContext : issueTypeContextsMap.keySet()) {
                Set<IssueTypeContext> issueTypeContexts;
                if (projectContext == AllProjectsContext.INSTANCE || (issueTypeContexts = issueTypeContextsMap.get(projectContext)) == null) continue;
                for (IssueTypeContext issueTypeContext : issueTypeContexts) {
                    if (!issueTypeContextsInAllProjects.contains(issueTypeContext)) continue;
                    projectIssueTypeContexts.add(new ProjectIssueTypeContextImpl(projectContext, issueTypeContext));
                }
            }
        }
        return projectIssueTypeContexts;
    }

    @Nonnull
    private Set<ProjectIssueTypeContext> toProjectIssueTypeContextSet(@Nonnull Map<ProjectContext, Set<IssueTypeContext>> projectIssueTypeContextMap) {
        HashSet projectIssueTypeContexts = Sets.newHashSet();
        if (!projectIssueTypeContextMap.isEmpty()) {
            for (Map.Entry<ProjectContext, Set<IssueTypeContext>> entry : projectIssueTypeContextMap.entrySet()) {
                for (IssueTypeContext issueTypeContext : entry.getValue()) {
                    projectIssueTypeContexts.add(new ProjectIssueTypeContextImpl(entry.getKey(), issueTypeContext));
                }
            }
        }
        return projectIssueTypeContexts;
    }

    private static enum CombineType {
        INTERSECT,
        UNION;

    }
}

