/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.jql.builder;

import com.atlassian.jira.jql.builder.JqlFieldReferenceBuilder;
import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.concurrent.ThreadSafe;

@ThreadSafe
public final class JqlFieldReference {
    private final String name;
    private final String property;
    private final String reference;

    JqlFieldReference(String name, String property) {
        this(name, property, null);
    }

    JqlFieldReference(String name, String property, String reference) {
        Preconditions.checkArgument((!Strings.isNullOrEmpty((String)name) ? 1 : 0) != 0, (Object)"Field name is not supposed to be empty");
        Preconditions.checkArgument((!Strings.isNullOrEmpty((String)property) ? 1 : 0) != 0, (Object)"Property is not supposed to be empty");
        this.name = name;
        this.property = property;
        this.reference = reference;
    }

    @Nonnull
    public String getName() {
        return this.name;
    }

    @Nonnull
    public String getProperty() {
        return this.property;
    }

    @Nullable
    public String getReference() {
        return this.reference;
    }

    public String toJql() {
        if (this.hasReference()) {
            return String.format("%s[%s].%s", this.name, this.property, this.reference);
        }
        return String.format("%s[%s]", this.name, this.property);
    }

    public static JqlFieldReferenceBuilder create() {
        return new JqlFieldReferenceBuilder();
    }

    public boolean hasReference() {
        return !Strings.isNullOrEmpty((String)this.reference);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        JqlFieldReference that = (JqlFieldReference)o;
        if (!this.name.equals(that.name)) {
            return false;
        }
        if (!this.property.equals(that.property)) {
            return false;
        }
        return this.reference != null ? this.reference.equals(that.reference) : that.reference == null;
    }

    public int hashCode() {
        int result = this.name.hashCode();
        result = 31 * result + this.property.hashCode();
        result = 31 * result + (this.reference != null ? this.reference.hashCode() : 0);
        return result;
    }
}

