/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.event.user.anonymize;

import com.atlassian.analytics.api.annotations.EventName;
import java.util.Objects;
import javax.annotation.Nonnull;

@EventName(value="jira.user.name.changed")
public class UserNameChangedEvent {
    private final String oldUserName;
    private final String newUserName;

    public UserNameChangedEvent(@Nonnull String oldUserName, @Nonnull String newUserName) {
        this.oldUserName = Objects.requireNonNull(oldUserName);
        this.newUserName = Objects.requireNonNull(newUserName);
    }

    @Nonnull
    public String getOldUserName() {
        return this.oldUserName;
    }

    @Nonnull
    public String getNewUserName() {
        return this.newUserName;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        UserNameChangedEvent that = (UserNameChangedEvent)o;
        return Objects.equals(this.oldUserName, that.oldUserName) && Objects.equals(this.newUserName, that.newUserName);
    }

    public int hashCode() {
        return Objects.hash(this.oldUserName, this.newUserName);
    }
}

