/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.auditing;

import com.atlassian.annotations.ExperimentalApi;
import javax.annotation.Nullable;

@ExperimentalApi
public enum AuditingCategory {
    AUDITING("auditing", "jira.auditing.category"),
    ADVANCED_AUDITING("advanced auditing", "atlassian.audit.event.category.audit"),
    USER_MANAGEMENT("user management", "jira.auditing.category.usermanagement"),
    GROUP_MANAGEMENT("group management", "jira.auditing.category.groupmanagement"),
    PERMISSIONS("permissions", "jira.auditing.category.permissions"),
    WORKFLOWS("workflows", "jira.auditing.category.workflows"),
    NOTIFICATIONS("notifications", "jira.auditing.category.notifications"),
    FIELDS("fields", "jira.auditing.category.fields"),
    PROJECTS("projects", "jira.auditing.category.projects"),
    SYSTEM("system", "jira.auditing.category.system"),
    MIGRATION("migration", "jira.auditing.category.migration"),
    APPLICATIONS("applications", "jira.auditing.category.applications"),
    USER_DATA_TRANSFER("user data transfer", "jira.auditing.category.userdatatransfer"),
    SPRINTS("sprints", "jira.auditing.category.sprints"),
    BOARDS("boards ", "jira.auditing.category.boards"),
    ISSUE_TYPES("issue types", "jira.auditing.category.issuetypes"),
    ISSUE("issue", "jira.auditing.category.issue"),
    GENERAL_CONFIGURATION("configuration", "jira.auditing.category.generalconfiguration"),
    DASHBOARDS("dashboards", "jira.auditing.category.dashboards"),
    FILTERS("filters", "jira.auditing.category.filters"),
    SEARCH("search", "jira.auditing.category.search"),
    MAIL_SETTINGS("mail settings", "jira.auditing.category.mailsettings"),
    USER_INTERFACE("user interface", "jira.auditing.category.userinterface"),
    SCREENS("screens", "jira.auditing.category.screens"),
    INDEXING("indexing", "jira.auditing.category.indexing"),
    LOGIN("login", "jira.auditing.category.login"),
    FIELD_CONFIG_SCHEME("field config scheme", "jira.auditing.category.field.config"),
    CLUSTERING("clustering", "jira.auditing.category.clustering");

    private final String id;
    private final String nameI18nKey;

    private AuditingCategory(String id, String nameI18nKey) {
        this.id = id;
        this.nameI18nKey = nameI18nKey;
    }

    public String getId() {
        return this.id;
    }

    public String getNameI18nKey() {
        return this.nameI18nKey;
    }

    @Nullable
    public static AuditingCategory getCategoryById(String categoryId) {
        for (AuditingCategory category : AuditingCategory.values()) {
            if (!category.getId().equalsIgnoreCase(categoryId)) continue;
            return category;
        }
        return null;
    }

    @Nullable
    public static AuditingCategory getCategoryByNameI18nKey(String nameI18nKey) {
        for (AuditingCategory category : AuditingCategory.values()) {
            if (!category.getNameI18nKey().equalsIgnoreCase(nameI18nKey)) continue;
            return category;
        }
        return null;
    }

    @Nullable
    public static AuditingCategory getCategoryByIdOrName(String idOrName) {
        for (AuditingCategory category : AuditingCategory.values()) {
            if (!category.getId().equalsIgnoreCase(idOrName)) continue;
            return category;
        }
        for (AuditingCategory category : AuditingCategory.values()) {
            if (!category.name().equalsIgnoreCase(idOrName)) continue;
            return category;
        }
        return null;
    }
}

