/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.issue.customfields.searchers.transformer;

import com.atlassian.jira.issue.search.ClauseNames;
import com.atlassian.jira.issue.search.searchers.transformer.SimpleNavigatorCollectorVisitor;
import com.atlassian.jira.jql.operand.JqlOperandResolver;
import com.atlassian.jira.util.collect.CollectionBuilder;
import com.atlassian.jira.util.dbc.Assertions;
import com.atlassian.query.Query;
import com.atlassian.query.clause.TerminalClause;
import com.atlassian.query.operator.Operator;
import java.util.Collections;
import java.util.List;

public class NumberRangeCustomFieldInputHelper {
    private final ClauseNames clauseNames;
    private final JqlOperandResolver jqlOperandResolver;

    public NumberRangeCustomFieldInputHelper(ClauseNames clauseNames, JqlOperandResolver jqlOperandResolver) {
        this.clauseNames = Assertions.notNull("clauseNames", clauseNames);
        this.jqlOperandResolver = Assertions.notNull("jqlOperandResolver", jqlOperandResolver);
    }

    public List<TerminalClause> getValuesFromQuery(Query query) {
        Assertions.notNull("query", query);
        Assertions.notNull("whereClause", query.getWhereClause());
        SimpleNavigatorCollectorVisitor simpleNavigatorCollectorVisitor = this.createSimpleNavigatorCollectorVisitor();
        query.getWhereClause().accept(simpleNavigatorCollectorVisitor);
        if (simpleNavigatorCollectorVisitor.isValid()) {
            List<TerminalClause> clauses = simpleNavigatorCollectorVisitor.getClauses();
            if (clauses.isEmpty()) {
                return Collections.emptyList();
            }
            if (clauses.size() == 1) {
                TerminalClause clause = clauses.get(0);
                if (this.isValidClause(clause)) {
                    return Collections.singletonList(clause);
                }
            } else if (clauses.size() == 2) {
                TerminalClause clause1 = clauses.get(0);
                TerminalClause clause2 = clauses.get(1);
                if (this.isValidClause(clause1) && this.isValidClause(clause2) && clause1.getOperator() != clause2.getOperator()) {
                    return CollectionBuilder.newBuilder(clause1, clause2).asList();
                }
            }
        }
        return null;
    }

    protected SimpleNavigatorCollectorVisitor createSimpleNavigatorCollectorVisitor() {
        return new SimpleNavigatorCollectorVisitor(this.clauseNames);
    }

    private boolean isValidClause(TerminalClause clause) {
        return !this.jqlOperandResolver.isEmptyOperand(clause.getOperand()) && !this.jqlOperandResolver.isListOperand(clause.getOperand()) && (clause.getOperator() == Operator.GREATER_THAN_EQUALS || clause.getOperator() == Operator.LESS_THAN_EQUALS);
    }
}

