/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.issue.statistics;

import com.atlassian.jira.issue.search.SearchRequest;
import com.atlassian.jira.issue.search.SearchRequestAppender;
import com.atlassian.jira.issue.search.util.SearchRequestAddendumBuilder;
import com.atlassian.jira.issue.statistics.StatisticsMapper;
import com.atlassian.jira.jql.builder.JqlClauseBuilder;
import com.atlassian.jira.util.dbc.Assertions;
import java.util.Comparator;
import java.util.Date;
import java.util.TimeZone;
import org.jfree.data.time.RegularTimePeriod;
import org.jfree.data.time.TimePeriod;

public class DatePeriodStatisticsMapper
implements StatisticsMapper<TimePeriod>,
SearchRequestAppender.Factory<TimePeriod> {
    private final Class timePeriodClass;
    private final TimeZone periodTimeZone;
    private final String documentConstant;

    public DatePeriodStatisticsMapper(Class timePeriodClass, String documentConstant, TimeZone periodTimeZone) {
        this.documentConstant = documentConstant;
        this.timePeriodClass = timePeriodClass;
        this.periodTimeZone = periodTimeZone;
    }

    @Override
    @Deprecated
    public SearchRequest getSearchUrlSuffix(TimePeriod timePeriod, SearchRequest searchRequest) {
        return this.getSearchRequestAppender().appendInclusiveSingleValueClause(timePeriod, searchRequest);
    }

    @Override
    public SearchRequestAppender<TimePeriod> getSearchRequestAppender() {
        return new TimePeriodSearchRequestAppender(this.documentConstant);
    }

    @Override
    public String getDocumentConstant() {
        return this.documentConstant;
    }

    @Override
    public TimePeriod getValueFromLuceneField(String documentValue) {
        Date date = new Date(Long.parseLong(documentValue));
        if (date == null) {
            return null;
        }
        return RegularTimePeriod.createInstance((Class)this.timePeriodClass, (Date)date, (TimeZone)this.periodTimeZone);
    }

    @Override
    public Comparator<TimePeriod> getComparator() {
        return new Comparator<TimePeriod>(){

            @Override
            public int compare(TimePeriod timePeriod1, TimePeriod timePeriod2) {
                if (timePeriod1 == null) {
                    return -1;
                }
                return timePeriod1.compareTo((Object)timePeriod2);
            }
        };
    }

    @Override
    public boolean isValidValue(TimePeriod value) {
        return value != null;
    }

    @Override
    public boolean isFieldAlwaysPartOfAnIssue() {
        return true;
    }

    static class TimePeriodSearchRequestAppender
    implements SearchRequestAddendumBuilder.AddendumCallback<TimePeriod>,
    SearchRequestAppender<TimePeriod> {
        private final String documentConstant;

        public TimePeriodSearchRequestAppender(String documentConstant) {
            this.documentConstant = Assertions.notNull(documentConstant);
        }

        @Override
        public void appendNonNullItem(TimePeriod timePeriod, JqlClauseBuilder clauseBuilder) {
            Date startDate = timePeriod.getStart();
            Date endDate = new Date(timePeriod.getEnd().getTime());
            clauseBuilder.addDateRangeCondition(this.documentConstant, startDate, endDate);
        }

        @Override
        public void appendNullItem(JqlClauseBuilder clauseBuilder) {
        }

        @Override
        public SearchRequest appendInclusiveSingleValueClause(TimePeriod value, SearchRequest searchRequest) {
            return SearchRequestAddendumBuilder.appendAndClause(value, searchRequest, this);
        }

        @Override
        public SearchRequest appendExclusiveMultiValueClause(Iterable<? extends TimePeriod> values, SearchRequest searchRequest) {
            return null;
        }
    }
}

