/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.config;

import com.atlassian.jira.config.Feature;
import com.atlassian.jira.util.dbc.Assertions;

public class FeatureFlag
implements Feature {
    public static final String POSTFIX_ENABLED = ".enabled";
    public static final String POSTFIX_DISABLED = ".disabled";
    private String featureKey;
    private boolean defaultOn;

    private FeatureFlag(String featureKey, boolean defaultOn) {
        this.featureKey = featureKey;
        this.defaultOn = defaultOn;
    }

    @Override
    public String featureKey() {
        return this.featureKey;
    }

    public boolean isOnByDefault() {
        return this.defaultOn;
    }

    public String enabledFeatureKey() {
        return this.featureKey + POSTFIX_ENABLED;
    }

    public String disabledFeatureKey() {
        return this.featureKey + POSTFIX_DISABLED;
    }

    public static FeatureFlag featureFlag(String featureKey) {
        Assertions.notNull(featureKey);
        return new FeatureFlag(featureKey, false);
    }

    public FeatureFlag onByDefault() {
        return new FeatureFlag(this.featureKey, true);
    }

    @Deprecated
    public FeatureFlag offByDefault() {
        return new FeatureFlag(this.featureKey, false);
    }

    @Deprecated
    public FeatureFlag defaultedTo(boolean defaultValue) {
        return new FeatureFlag(this.featureKey, defaultValue);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        FeatureFlag that = (FeatureFlag)o;
        return this.defaultOn == that.defaultOn && this.featureKey.equals(that.featureKey);
    }

    public int hashCode() {
        int result = this.featureKey.hashCode();
        result = 31 * result + (this.defaultOn ? 1 : 0);
        return result;
    }

    public String toString() {
        return this.featureKey + ":" + this.defaultOn;
    }
}

