/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.bc.project;

import com.atlassian.annotations.ExperimentalApi;
import com.atlassian.annotations.Internal;
import com.atlassian.annotations.PublicApi;
import com.atlassian.fugue.Either;
import com.atlassian.fugue.Option;
import com.atlassian.jira.bc.JiraServiceContext;
import com.atlassian.jira.bc.ServiceOutcome;
import com.atlassian.jira.bc.ServiceResult;
import com.atlassian.jira.bc.ServiceResultImpl;
import com.atlassian.jira.bc.project.ProjectAction;
import com.atlassian.jira.bc.project.ProjectCreationData;
import com.atlassian.jira.project.Project;
import com.atlassian.jira.project.UpdateProjectParameters;
import com.atlassian.jira.project.type.ProjectTypeKey;
import com.atlassian.jira.user.ApplicationUser;
import com.atlassian.jira.util.ErrorCollection;
import com.atlassian.jira.util.ErrorCollections;
import com.atlassian.jira.util.SimpleErrorCollection;
import com.atlassian.jira.web.action.RequestSourceType;
import java.io.Serializable;
import java.util.List;
import java.util.Optional;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

@PublicApi
public interface ProjectService {
    public static final String PROJECT_NAME = "projectName";
    public static final String PROJECT_KEY = "projectKey";
    public static final String PROJECT_LEAD = "projectLead";
    public static final String PROJECT_URL = "projectUrl";
    public static final String PROJECT_DESCRIPTION = "projectDescription";
    public static final String PROJECT_CATEGORY_ID = "projectCategoryId";
    public static final String PROJECT_TYPE = "projectType";
    public static final int MAX_NAME_LENGTH = 80;
    public static final int MIN_NAME_LENGTH = 2;
    public static final int MAX_KEY_LENGTH = 10;
    public static final int DEFAULT_NAME_LENGTH = 80;

    @Nonnull
    public CreateProjectValidationResult validateCreateProject(ApplicationUser var1, @Nonnull ProjectCreationData var2);

    public Project createProject(CreateProjectValidationResult var1);

    @Nonnull
    public CreateProjectValidationResult validateCreateProjectBasedOnExistingProject(ApplicationUser var1, @Nonnull Long var2, ProjectCreationData var3);

    public ServiceResult validateUpdateProject(ApplicationUser var1, String var2);

    public UpdateProjectValidationResult validateUpdateProject(ApplicationUser var1, String var2, String var3, String var4, String var5, String var6, Long var7);

    public UpdateProjectValidationResult validateUpdateProject(ApplicationUser var1, String var2, String var3, String var4, ApplicationUser var5, String var6, Long var7);

    public UpdateProjectValidationResult validateUpdateProject(ApplicationUser var1, Project var2, String var3, String var4, String var5, ApplicationUser var6, String var7, Long var8, Long var9);

    public UpdateProjectValidationResult validateUpdateProject(ApplicationUser var1, Project var2, String var3, String var4, String var5, String var6, String var7, Long var8, Long var9);

    public UpdateProjectValidationResult validateUpdateProject(ApplicationUser var1, String var2, String var3, String var4, String var5, String var6, Long var7, Long var8);

    public UpdateProjectValidationResult validateUpdateProject(ApplicationUser var1, String var2, String var3, String var4, ApplicationUser var5, String var6, Long var7, Long var8);

    public UpdateProjectValidationResult validateUpdateProject(ApplicationUser var1, UpdateProjectRequest var2);

    public Project updateProject(UpdateProjectValidationResult var1);

    public Either<Project, ErrorCollection> updateProjectType(ApplicationUser var1, Project var2, ProjectTypeKey var3);

    public DeleteProjectValidationResult validateDeleteProject(ApplicationUser var1, String var2);

    public DeleteProjectResult deleteProject(ApplicationUser var1, DeleteProjectValidationResult var2);

    public DeleteProjectResult deleteProjectAsynchronous(ApplicationUser var1, DeleteProjectValidationResult var2);

    public UpdateProjectSchemesValidationResult validateUpdateProjectSchemes(ApplicationUser var1, Long var2, Long var3, Long var4);

    public void updateProjectSchemes(UpdateProjectSchemesValidationResult var1, Project var2);

    @Deprecated
    public boolean isValidAllProjectData(JiraServiceContext var1, ProjectCreationData var2);

    public boolean isValidRequiredProjectData(JiraServiceContext var1, ProjectCreationData var2);

    public boolean isValidProjectKey(JiraServiceContext var1, String var2);

    public String getProjectKeyDescription();

    public GetProjectResult getProjectById(Long var1);

    public GetProjectResult getProjectById(ApplicationUser var1, Long var2);

    public GetProjectResult getProjectByIdForAction(ApplicationUser var1, Long var2, ProjectAction var3);

    public GetProjectResult getProjectByKey(String var1);

    public GetProjectResult getProjectByKey(ApplicationUser var1, String var2);

    public int getMaximumNameLength();

    public GetProjectResult getProjectByKeyForAction(ApplicationUser var1, String var2, ProjectAction var3);

    public int getMaximumKeyLength();

    public long getProjectCount();

    public ServiceOutcome<List<Project>> getAllProjects(ApplicationUser var1);

    public ServiceOutcome<List<Project>> getAllProjectsForAction(ApplicationUser var1, ProjectAction var2);

    @PublicApi
    public static class UpdateProjectRequest {
        private UpdateProjectParameters updateProjectParameters;
        private RequestSourceType requestSourceType = RequestSourceType.PAGE;

        @Internal
        public UpdateProjectRequest(Project originalProject) {
            this.updateProjectParameters = UpdateProjectParameters.forProject(originalProject.getId());
        }

        public UpdateProjectRequest key(String key) {
            this.updateProjectParameters.key(key);
            return this;
        }

        public UpdateProjectRequest name(String name) {
            this.updateProjectParameters.name(name);
            return this;
        }

        public UpdateProjectRequest description(String description) {
            this.updateProjectParameters.description(description);
            return this;
        }

        public UpdateProjectRequest leadUserKey(String leadUserKey) {
            this.updateProjectParameters.leadUserKey(leadUserKey);
            return this;
        }

        public UpdateProjectRequest leadUsername(String leadUsername) {
            this.updateProjectParameters.leadUsername(leadUsername);
            return this;
        }

        public UpdateProjectRequest url(String url) {
            this.updateProjectParameters.url(url);
            return this;
        }

        public UpdateProjectRequest assigneeType(Long assigneeType) {
            this.updateProjectParameters.assigneeType(assigneeType);
            return this;
        }

        public UpdateProjectRequest avatarId(Long avatarId) {
            this.updateProjectParameters.avatarId(avatarId);
            return this;
        }

        public UpdateProjectRequest projectType(String projectType) {
            this.updateProjectParameters.projectType(projectType);
            return this;
        }

        public UpdateProjectRequest projectCategoryId(Long projectCategoryId) {
            this.updateProjectParameters.projectCategoryId(projectCategoryId);
            return this;
        }

        public UpdateProjectRequest requestSourceType(RequestSourceType requestSourceType) {
            this.requestSourceType = requestSourceType;
            return this;
        }

        protected UpdateProjectParameters getUpdateProjectParameters() {
            return this.updateProjectParameters;
        }

        protected RequestSourceType getRequestSourceType() {
            return this.requestSourceType;
        }
    }

    @PublicApi
    public static class DeleteProjectResult
    extends ServiceResultImpl
    implements Serializable {
        private String redirectUrl = null;

        @Internal
        public DeleteProjectResult(ErrorCollection errorCollection) {
            super(errorCollection);
        }

        @Internal
        public DeleteProjectResult(String redirectUrl) {
            super(ErrorCollections.empty());
            this.redirectUrl = redirectUrl;
        }

        public String getRedirectUrl() {
            return this.redirectUrl;
        }
    }

    @PublicApi
    public static class DeleteProjectValidationResult
    extends AbstractProjectResult {
        @Internal
        public DeleteProjectValidationResult(ErrorCollection errorCollection) {
            super(errorCollection);
        }

        @Internal
        public DeleteProjectValidationResult(ErrorCollection errorCollection, Project project) {
            super(errorCollection, project);
        }
    }

    @PublicApi
    public static class GetProjectResult
    extends AbstractProjectResult {
        @Internal
        public GetProjectResult(ErrorCollection errorCollection) {
            super(errorCollection);
        }

        @Internal
        public GetProjectResult(Project project) {
            super((ErrorCollection)new SimpleErrorCollection(), project);
        }

        @Internal
        public GetProjectResult(ErrorCollection errorCollection, Project project) {
            super(errorCollection, project);
        }
    }

    @PublicApi
    public static abstract class AbstractProjectResult
    extends ServiceResultImpl
    implements ServiceOutcome<Project> {
        private Project project;

        @Internal
        public AbstractProjectResult(ErrorCollection errorCollection) {
            super(errorCollection);
        }

        @Internal
        public AbstractProjectResult(ErrorCollection errorCollection, Project project) {
            super(errorCollection);
            this.project = project;
        }

        public Project getProject() {
            return this.project;
        }

        @Override
        public Project get() {
            return this.project;
        }

        @Override
        public Project getReturnedValue() {
            return this.project;
        }
    }

    @PublicApi
    public static class UpdateProjectValidationResult
    extends AbstractProjectValidationResult {
        private final Project originalProject;
        private final UpdateProjectRequest updateProjectRequest;

        @Internal
        public UpdateProjectValidationResult(ErrorCollection errorCollection) {
            super(errorCollection);
            this.originalProject = null;
            this.updateProjectRequest = null;
        }

        @Deprecated
        @Internal
        public UpdateProjectValidationResult(ErrorCollection errorCollection, String name, String key, String description, String lead, String url, Long assigneeType, Long avatarId, Project originalProject) {
            this(errorCollection, name, key, description, lead, url, assigneeType, avatarId, originalProject, false, null);
        }

        @Deprecated
        @Internal
        public UpdateProjectValidationResult(ErrorCollection errorCollection, String name, String key, String description, String leadUsername, String url, Long assigneeType, Long avatarId, Project originalProject, boolean keyChanged, ApplicationUser user) {
            super(errorCollection, name, key, description, leadUsername, url, assigneeType, avatarId, keyChanged, user);
            this.originalProject = originalProject;
            this.updateProjectRequest = new UpdateProjectRequest(originalProject).name(name).key(key).description(description).leadUsername(leadUsername).url(url).assigneeType(assigneeType).avatarId(avatarId);
        }

        @Internal
        UpdateProjectValidationResult(ErrorCollection errorCollection, Project originalProject, ApplicationUser user, UpdateProjectRequest updateProjectRequest) {
            super(errorCollection, (String)updateProjectRequest.getUpdateProjectParameters().getName().getOrElse((Object)originalProject.getName()), (String)updateProjectRequest.getUpdateProjectParameters().getKey().getOrElse((Object)originalProject.getKey()), (String)updateProjectRequest.getUpdateProjectParameters().getDescription().getOrElse((Object)originalProject.getDescription()), (String)updateProjectRequest.getUpdateProjectParameters().getLeadUsername().getOrElse((Object)originalProject.getLeadUserName()), (String)updateProjectRequest.getUpdateProjectParameters().getUrl().getOrElse((Object)originalProject.getUrl()), (Long)updateProjectRequest.getUpdateProjectParameters().getAssigneeType().getOrElse((Object)originalProject.getAssigneeType()), (Long)updateProjectRequest.getUpdateProjectParameters().getAvatarId().getOrElse((Object)originalProject.getAvatar().getId()), UpdateProjectValidationResult.keyChanged(originalProject, updateProjectRequest), user);
            this.originalProject = originalProject;
            this.updateProjectRequest = updateProjectRequest;
        }

        private static boolean keyChanged(Project originalProject, UpdateProjectRequest updateProjectRequest) {
            Option<String> newProjectKey = updateProjectRequest.getUpdateProjectParameters().getKey();
            return newProjectKey.isDefined() && !((String)newProjectKey.get()).equals(originalProject.getKey());
        }

        public Project getOriginalProject() {
            return this.originalProject;
        }

        public UpdateProjectRequest getUpdateProjectRequest() {
            return this.updateProjectRequest;
        }
    }

    @PublicApi
    public static class CreateProjectValidationResult
    extends ServiceResultImpl {
        private final ApplicationUser user;
        private final Optional<Long> existingProjectId;
        private final ProjectCreationData projectCreationData;

        @Internal
        public CreateProjectValidationResult(ErrorCollection errorCollection) {
            this(errorCollection, null, null, Optional.empty());
        }

        @Internal
        public CreateProjectValidationResult(ErrorCollection errorCollection, ApplicationUser user, ProjectCreationData projectCreationData) {
            this(errorCollection, user, projectCreationData, Optional.empty());
        }

        public CreateProjectValidationResult(ErrorCollection errorCollection, ApplicationUser user, ProjectCreationData projectCreationData, Optional<Long> existingProjectId) {
            super(errorCollection);
            this.user = user;
            this.existingProjectId = existingProjectId;
            this.projectCreationData = projectCreationData;
        }

        public ProjectCreationData getProjectCreationData() {
            return this.projectCreationData;
        }

        public ApplicationUser getUser() {
            return this.user;
        }

        public Optional<Long> getExistingProjectId() {
            return this.existingProjectId;
        }
    }

    @PublicApi
    public static abstract class AbstractProjectValidationResult
    extends ServiceResultImpl {
        private final String name;
        private final String key;
        private final String description;
        private final String leadName;
        private final String url;
        private final Long assigneeType;
        private final Long avatarId;
        private final boolean keyChanged;
        private final ApplicationUser user;

        @Internal
        public AbstractProjectValidationResult(ErrorCollection errorCollection) {
            super(errorCollection);
            this.name = null;
            this.key = null;
            this.description = null;
            this.leadName = null;
            this.url = null;
            this.assigneeType = null;
            this.avatarId = null;
            this.keyChanged = false;
            this.user = null;
        }

        @Internal
        public AbstractProjectValidationResult(ErrorCollection errorCollection, String name, String key, String description, String leadName, String url, Long assigneeType, Long avatarId, boolean keyChanged, ApplicationUser user) {
            super(errorCollection);
            this.name = name;
            this.key = key;
            this.description = description;
            this.leadName = leadName;
            this.url = url;
            this.assigneeType = assigneeType;
            this.avatarId = avatarId;
            this.keyChanged = keyChanged;
            this.user = user;
        }

        public String getName() {
            return this.name;
        }

        public String getKey() {
            return this.key;
        }

        public String getDescription() {
            return this.description;
        }

        public String getLeadUsername() {
            return this.leadName;
        }

        public String getLead() {
            return this.leadName;
        }

        public String getUrl() {
            return this.url;
        }

        public Long getAssigneeType() {
            return this.assigneeType;
        }

        public Long getAvatarId() {
            return this.avatarId;
        }

        @ExperimentalApi
        public boolean isKeyChanged() {
            return this.keyChanged;
        }

        @ExperimentalApi
        @Nullable
        public ApplicationUser getUser() {
            return this.user;
        }
    }

    @PublicApi
    public static class UpdateProjectSchemesValidationResult
    extends ServiceResultImpl {
        private Long permissionSchemeId;
        private Long notificationSchemeId;
        private Long issueSecuritySchemeId;

        @Internal
        public UpdateProjectSchemesValidationResult(ErrorCollection errorCollection) {
            super(errorCollection);
        }

        @Internal
        public UpdateProjectSchemesValidationResult(ErrorCollection errorCollection, Long permissionSchemeId, Long notificationSchemeId, Long issueSecuritySchemeId) {
            super(errorCollection);
            this.permissionSchemeId = permissionSchemeId;
            this.notificationSchemeId = notificationSchemeId;
            this.issueSecuritySchemeId = issueSecuritySchemeId;
        }

        public Long getPermissionSchemeId() {
            return this.permissionSchemeId;
        }

        public Long getNotificationSchemeId() {
            return this.notificationSchemeId;
        }

        public Long getIssueSecuritySchemeId() {
            return this.issueSecuritySchemeId;
        }
    }
}

