/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.user;

import com.atlassian.jira.component.ComponentAccessor;
import com.atlassian.jira.user.ApplicationUser;
import com.atlassian.jira.user.util.UserManager;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.apache.commons.lang.StringUtils;

public class UserUtils {
    public static boolean userExists(String username) {
        return UserUtils.getUser(username) != null;
    }

    public static ApplicationUser getUser(String username) {
        return UserUtils.getUserManager().getUserObject(username);
    }

    public static ApplicationUser getUserEvenWhenUnknown(String username) {
        return UserUtils.getUserManager().getUserEvenWhenUnknown(username);
    }

    public static ApplicationUser getUserByEmail(String emailAddress) {
        if ((emailAddress = StringUtils.trimToNull((String)emailAddress)) == null) {
            return null;
        }
        for (ApplicationUser user : UserUtils.getAllUsers()) {
            if (!emailAddress.equalsIgnoreCase(user.getEmailAddress())) continue;
            return user;
        }
        return null;
    }

    public static List getUsersByEmail(String email) {
        ArrayList<ApplicationUser> users = new ArrayList<ApplicationUser>();
        String emailAddress = StringUtils.trimToNull((String)email);
        if (emailAddress != null) {
            for (ApplicationUser user : UserUtils.getAllUsers()) {
                if (!emailAddress.equalsIgnoreCase(user.getEmailAddress())) continue;
                users.add(user);
            }
        }
        return users;
    }

    @Deprecated
    public static Collection<ApplicationUser> getAllUsers() {
        return UserUtils.getUserManager().getUsers();
    }

    public static UserManager getUserManager() {
        return ComponentAccessor.getUserManager();
    }
}

