/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.issue.customfields;

import com.atlassian.annotations.PublicApi;
import com.google.common.base.Preconditions;
import javax.annotation.Nonnull;
import org.apache.commons.lang3.StringUtils;

@PublicApi
public final class CloneOptionConfiguration {
    public static final CloneOptionConfiguration DO_NOT_DISPLAY = new CloneOptionConfiguration(false, "", false);
    private final boolean shouldDisplayOption;
    private final String optionLabel;
    private final boolean optionSelectedByDefault;

    private CloneOptionConfiguration(boolean shouldDisplayOption, String optionLabel, boolean optionSelectedByDefault) {
        this.shouldDisplayOption = shouldDisplayOption;
        this.optionLabel = optionLabel;
        this.optionSelectedByDefault = optionSelectedByDefault;
    }

    public boolean shouldDisplayOption() {
        return this.shouldDisplayOption;
    }

    @Nonnull
    public String getOptionLabel() {
        return this.optionLabel;
    }

    public boolean isOptionSelectedByDefault() {
        return this.optionSelectedByDefault;
    }

    @Nonnull
    public static CloneOptionConfiguration withOptionLabel(String optionLabel) {
        Preconditions.checkArgument((boolean)StringUtils.isNotBlank((CharSequence)optionLabel), (Object)"Option label needs to be non-null and non-empty when option is being displayed.");
        return new CloneOptionConfiguration(true, optionLabel, false);
    }

    @Nonnull
    public CloneOptionConfiguration selectOptionByDefault() {
        Preconditions.checkState((boolean)this.shouldDisplayOption(), (Object)"Shouldn't be setting option's initial state on configuration for option that is not displayed.");
        return new CloneOptionConfiguration(true, this.optionLabel, true);
    }
}

