/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.charts.jfreechart;

import com.atlassian.annotations.Internal;
import com.atlassian.core.util.RandomGenerator;
import com.atlassian.jira.charts.jfreechart.AltAndTitleTagFragmentGenerator;
import com.atlassian.jira.charts.util.ChartUtils;
import com.atlassian.jira.component.ComponentAccessor;
import com.atlassian.jira.io.SessionNotFoundException;
import com.atlassian.jira.io.TempFileFactory;
import com.atlassian.util.profiling.UtilTimerStack;
import com.google.common.annotations.VisibleForTesting;
import java.awt.image.BufferedImage;
import java.io.File;
import java.io.IOException;
import org.jfree.chart.ChartRenderingInfo;
import org.jfree.chart.ChartUtilities;
import org.jfree.chart.JFreeChart;
import org.jfree.chart.imagemap.ImageMapUtilities;
import org.jfree.chart.imagemap.StandardURLTagFragmentGenerator;
import org.jfree.chart.imagemap.ToolTipTagFragmentGenerator;
import org.jfree.chart.imagemap.URLTagFragmentGenerator;
import org.jfree.chart.servlet.ServletUtilities;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ChartHelper {
    private static final Logger log = LoggerFactory.getLogger(ChartHelper.class);
    private final JFreeChart chart;
    private final TempFileFactory tempFileFactory;
    private final ChartUtils chartUtils;
    private ChartRenderingInfo renderingInfo;
    private String location;
    private String imageMapHtml;
    private String imageMapName;
    private BufferedImage image;

    public ChartHelper(JFreeChart chart) {
        this(chart, ComponentAccessor.getComponent(TempFileFactory.class), ComponentAccessor.getComponent(ChartUtils.class));
    }

    @VisibleForTesting
    @Internal
    public ChartHelper(JFreeChart chart, TempFileFactory tempFileFactory, ChartUtils chartUtils) {
        this.chart = chart;
        this.tempFileFactory = tempFileFactory;
        this.chartUtils = chartUtils;
    }

    public JFreeChart getChart() {
        return this.chart;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void generateInline(int width, int height) throws IOException {
        if (log.isDebugEnabled()) {
            log.debug("ChartHelper.generate() Create a ChartRenderingInfo.");
        }
        this.renderingInfo = new ChartRenderingInfo();
        String logLine = "ChartHelper calling JFreeChart: JFreeChart.createBufferedImage()";
        UtilTimerStack.push((String)"ChartHelper calling JFreeChart: JFreeChart.createBufferedImage()");
        try {
            log.debug("ChartHelper.generateInline(): Use JFreeChart to create PNG file.");
            this.image = this.createChartImageInline(this.chart, width, height, this.renderingInfo);
            log.debug("ChartHelper.generateInline(): PNG file created .");
        }
        finally {
            UtilTimerStack.pop((String)"ChartHelper calling JFreeChart: JFreeChart.createBufferedImage()");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Deprecated
    public void generate(int width, int height) throws IOException {
        if (log.isDebugEnabled()) {
            log.debug("ChartHelper.generate() Create a ChartRenderingInfo.");
        }
        this.renderingInfo = new ChartRenderingInfo();
        String logLine = "ChartHelper calling JFreeChart: ServletUtilities.saveChartAsPNG()";
        UtilTimerStack.push((String)"ChartHelper calling JFreeChart: ServletUtilities.saveChartAsPNG()");
        try {
            log.debug("ChartHelper.generate(): Use JFreeChart to create PNG file.");
            this.location = this.createChartImage(this.chart, width, height, this.renderingInfo);
            log.debug("ChartHelper.generate(): PNG file created in '" + this.location + "'.");
        }
        finally {
            UtilTimerStack.pop((String)"ChartHelper calling JFreeChart: ServletUtilities.saveChartAsPNG()");
        }
    }

    private String createChartImage(JFreeChart chart, int width, int height, ChartRenderingInfo renderingInfo) throws IOException {
        File tempFile = this.getChartTempFile();
        ChartUtilities.saveChartAsPNG((File)tempFile, (JFreeChart)chart, (int)width, (int)height, (ChartRenderingInfo)renderingInfo);
        return tempFile.getName();
    }

    private BufferedImage createChartImageInline(JFreeChart chart, int width, int height, ChartRenderingInfo renderingInfo) throws IOException {
        return chart.createBufferedImage(width, height, renderingInfo);
    }

    public ChartRenderingInfo getRenderingInfo() {
        return this.renderingInfo;
    }

    @Deprecated
    public String getLocation() {
        return this.location;
    }

    public String getImageMap() {
        return this.getImageMapHtml();
    }

    public String getImageMapHtml() {
        if (this.imageMapHtml == null) {
            this.imageMapName = ChartHelper.generateRandomImageMapName();
            this.imageMapHtml = ImageMapUtilities.getImageMap((String)this.imageMapName, (ChartRenderingInfo)this.renderingInfo, (ToolTipTagFragmentGenerator)new AltAndTitleTagFragmentGenerator(), (URLTagFragmentGenerator)new StandardURLTagFragmentGenerator());
        }
        return this.imageMapHtml;
    }

    private static String generateRandomImageMapName() {
        return "chart-" + RandomGenerator.randomString((int)10);
    }

    public String getImageMapName() {
        return this.imageMapName;
    }

    private void markAsTemporaryFile(String location) {
        if (this.tempFileFactory != null) {
            try {
                this.tempFileFactory.makeSessionTempFile(location);
            }
            catch (SessionNotFoundException sessionNotFoundException) {
                // empty catch block
            }
        }
    }

    public BufferedImage getImage() {
        return this.image;
    }

    private File getChartTempFile() throws IOException {
        return File.createTempFile(ServletUtilities.getTempOneTimeFilePrefix(), ".png", this.chartUtils.getChartDirectory());
    }
}

