/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.issue.index.indexers.impl;

import com.atlassian.jira.issue.Issue;
import com.atlassian.jira.issue.customfields.converters.UserConverter;
import com.atlassian.jira.issue.fields.CustomField;
import com.atlassian.jira.issue.index.indexers.impl.AbstractCustomFieldIndexer;
import com.atlassian.jira.user.ApplicationUser;
import com.atlassian.jira.util.dbc.Assertions;
import com.atlassian.jira.web.FieldVisibilityManager;
import org.apache.lucene.document.Document;
import org.apache.lucene.document.Field;
import org.apache.lucene.document.Fieldable;

public class UserCustomFieldIndexer
extends AbstractCustomFieldIndexer {
    private final CustomField customField;
    private final UserConverter userConverter;

    public UserCustomFieldIndexer(FieldVisibilityManager fieldVisibilityManager, CustomField customField, UserConverter userConverter) {
        super(fieldVisibilityManager, Assertions.notNull("customField", customField));
        this.userConverter = userConverter;
        this.customField = customField;
    }

    @Override
    public void addDocumentFieldsSearchable(Document doc, Issue issue) {
        this.addDocumentFields(doc, issue, Field.Index.NOT_ANALYZED_NO_NORMS);
    }

    @Override
    public void addDocumentFieldsNotSearchable(Document doc, Issue issue) {
        this.addDocumentFields(doc, issue, Field.Index.NO);
    }

    private void addDocumentFields(Document doc, Issue issue, Field.Index indexType) {
        Object value = this.customField.getValue(issue);
        if (value instanceof ApplicationUser) {
            String userId = this.userConverter.getDbString((ApplicationUser)value);
            doc.add((Fieldable)new Field(this.getDocumentFieldId(), userId, Field.Store.YES, indexType));
        }
    }
}

