/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.imports.project.customfield;

import com.atlassian.jira.imports.project.customfield.ExternalCustomFieldValue;
import com.atlassian.jira.imports.project.customfield.ProjectCustomFieldImporter;
import com.atlassian.jira.imports.project.mapper.ProjectImportMapper;
import com.atlassian.jira.issue.fields.config.FieldConfig;
import com.atlassian.jira.util.I18nHelper;
import com.atlassian.jira.util.MessageSet;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class VersionCustomFieldImporter
implements ProjectCustomFieldImporter {
    private static final Logger log = LoggerFactory.getLogger(VersionCustomFieldImporter.class);

    @Override
    public MessageSet canMapImportValue(ProjectImportMapper projectImportMapper, ExternalCustomFieldValue customFieldValue, FieldConfig fieldConfig, I18nHelper i18n) {
        return null;
    }

    @Override
    public ProjectCustomFieldImporter.MappedCustomFieldValue getMappedImportValue(ProjectImportMapper projectImportMapper, ExternalCustomFieldValue customFieldValue, FieldConfig fieldConfig) {
        String oldVersionId = this.getNonDecimalValue(customFieldValue.getValue());
        String mappedVersionId = projectImportMapper.getVersionMapper().getMappedId(oldVersionId);
        if (mappedVersionId == null) {
            log.warn("The version custom field '" + fieldConfig.getCustomField().getName() + "' references a version with id '" + oldVersionId + "' that is an orphan value. The value will not be imported.");
        }
        return new ProjectCustomFieldImporter.MappedCustomFieldValue(mappedVersionId);
    }

    private String getNonDecimalValue(String value) {
        if (value != null) {
            return new Long(new Double(value).intValue()).toString();
        }
        return null;
    }
}

