/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.issue.customfields.searchers.information;

import com.atlassian.jira.issue.fields.CustomField;
import com.atlassian.jira.issue.index.indexers.FieldIndexer;
import com.atlassian.jira.issue.search.searchers.SearcherGroupType;
import com.atlassian.jira.issue.search.searchers.information.GenericSearcherInformation;
import com.atlassian.jira.util.collect.CollectionUtil;
import com.atlassian.jira.util.dbc.Assertions;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.atomic.AtomicReference;

public class CustomFieldSearcherInformation
extends GenericSearcherInformation<CustomField> {
    private final List<FieldIndexer> indexers;
    private final AtomicReference<CustomField> fieldReference;

    public CustomFieldSearcherInformation(String id, String nameKey, List<? extends FieldIndexer> indexers, AtomicReference<CustomField> fieldReference) {
        super(id, nameKey, Collections.emptyList(), fieldReference, SearcherGroupType.CUSTOM);
        this.indexers = CollectionUtil.copyAsImmutableList((Collection)Assertions.notNull("indexers", indexers));
        Assertions.stateTrue("indexers", !this.indexers.isEmpty());
        this.fieldReference = fieldReference;
    }

    @Override
    public List<FieldIndexer> getRelatedIndexers() {
        CustomField customField = this.fieldReference.get();
        Assertions.stateNotNull("customField", customField);
        List<FieldIndexer> relatedIndexers = customField.getCustomFieldType().getRelatedIndexers(customField);
        if (relatedIndexers != null) {
            return relatedIndexers;
        }
        return this.indexers;
    }

    @Override
    public String getNameKey() {
        return this.fieldReference.get().getNameKey();
    }
}

