/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.event.project;

import com.atlassian.jira.component.ComponentAccessor;
import com.atlassian.jira.project.version.Version;
import com.atlassian.jira.util.dbc.Assertions;
import com.google.common.base.Objects;
import javax.annotation.Nonnull;

public class AbstractVersionEvent {
    private final Version version;

    public AbstractVersionEvent(long versionId) {
        this.version = Assertions.notNull("Version should exist", ComponentAccessor.getVersionManager().getVersion(versionId));
    }

    public AbstractVersionEvent(@Nonnull Version version) {
        this.version = version;
    }

    public long getVersionId() {
        return this.version.getId();
    }

    @Nonnull
    public Version getVersion() {
        return this.version;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        AbstractVersionEvent that = (AbstractVersionEvent)o;
        return Objects.equal((Object)this.version.getId(), (Object)that.version.getId());
    }

    public int hashCode() {
        return (int)(this.version.getId() ^ this.version.getId() >>> 32);
    }
}

