/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.web.action;

import com.atlassian.http.url.SameOrigin;
import com.atlassian.jira.util.velocity.VelocityRequestContextFactory;
import com.atlassian.jira.web.action.RedirectSanitiser;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import javax.annotation.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RedirectSanitiserImpl
implements RedirectSanitiser {
    private static final Logger securityLog = LoggerFactory.getLogger((String)"com.atlassian.jira.login.security");
    private final VelocityRequestContextFactory velocityRequestContextFactory;

    public RedirectSanitiserImpl(VelocityRequestContextFactory velocityRequestContextFactory) {
        this.velocityRequestContextFactory = velocityRequestContextFactory;
    }

    @Override
    public boolean canRedirectTo(@Nullable String redirectUri) {
        if (redirectUri == null) {
            return true;
        }
        try {
            URI uri = new URI(redirectUri);
            if (uri.getHost() != null && uri.getScheme() == null) {
                return false;
            }
            if (this.getCanonicalBaseURL() == null) {
                return !uri.isAbsolute();
            }
            URI baseUrl = new URI(this.getCanonicalBaseURL());
            if (uri.isAbsolute() && !SameOrigin.isSameOrigin((URI)uri, (URI)baseUrl)) {
                return false;
            }
            return uri.getPath() == null || !uri.getPath().contains(":");
        }
        catch (MalformedURLException | URISyntaxException e) {
            return false;
        }
    }

    @Override
    @Nullable
    public String makeSafeRedirectUrl(@Nullable String redirectUrl) {
        if (redirectUrl == null) {
            return null;
        }
        if (!this.canRedirectTo(redirectUrl)) {
            securityLog.warn("Potential malicious redirect detected: " + redirectUrl);
            return null;
        }
        return redirectUrl;
    }

    protected String getCanonicalBaseURL() {
        return this.velocityRequestContextFactory.getJiraVelocityRequestContext().getCanonicalBaseUrl();
    }
}

