/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.bc.project;

import com.atlassian.jira.project.Project;
import com.atlassian.jira.security.PermissionManager;
import com.atlassian.jira.security.Permissions;
import com.atlassian.jira.security.plugin.ProjectPermissionKey;
import com.atlassian.jira.user.ApplicationUser;

public enum ProjectAction {
    VIEW_PROJECT(new int[]{0, 10, 23}, "admin.errors.project.no.view.permission"),
    VIEW_ISSUES(new int[]{10}, "admin.errors.project.no.browse.permission"),
    EDIT_PROJECT_CONFIG(new int[]{0, 23}, "admin.errors.project.no.config.permission"),
    EDIT_PROJECT_KEY(new int[]{0}, "admin.projects.service.error.no.admin.permission.key");

    private final int[] permissions;
    private final String errorKey;

    private ProjectAction(int[] permissions, String errorKey) {
        this.permissions = permissions;
        this.errorKey = errorKey;
    }

    public int[] getPermissions() {
        return this.permissions;
    }

    public String getErrorKey() {
        return this.errorKey;
    }

    public boolean hasPermission(PermissionManager manager, ApplicationUser user, Project project) {
        for (int permission : this.permissions) {
            if (!(Permissions.isGlobalPermission(permission) ? manager.hasPermission(permission, user) : manager.hasPermission(new ProjectPermissionKey(permission), project, user))) continue;
            return true;
        }
        return false;
    }
}

