/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.plugin.webfragment.conditions;

import com.atlassian.annotations.ExperimentalSpi;
import com.atlassian.jira.permission.GlobalPermissionKey;
import com.atlassian.jira.plugin.webfragment.conditions.AbstractWebCondition;
import com.atlassian.jira.plugin.webfragment.conditions.cache.ConditionCacheKeys;
import com.atlassian.jira.plugin.webfragment.conditions.cache.RequestCachingConditionHelper;
import com.atlassian.jira.plugin.webfragment.model.JiraHelper;
import com.atlassian.jira.security.GlobalPermissionManager;
import com.atlassian.jira.user.ApplicationUser;
import com.atlassian.plugin.PluginParseException;
import com.google.common.base.Supplier;
import java.util.Map;

@ExperimentalSpi
public abstract class AbstractFixedPermissionCondition
extends AbstractWebCondition {
    protected final GlobalPermissionManager permissionManager;
    protected final GlobalPermissionKey permission;

    public AbstractFixedPermissionCondition(GlobalPermissionManager permissionManager, GlobalPermissionKey globalPermissionKey) {
        this.permissionManager = permissionManager;
        this.permission = globalPermissionKey;
    }

    @Override
    public final void init(Map<String, String> params) throws PluginParseException {
        super.init(params);
    }

    @Override
    public final boolean shouldDisplay(ApplicationUser user, JiraHelper jiraHelper) {
        return RequestCachingConditionHelper.cacheConditionResultInRequest(ConditionCacheKeys.permission(this.permission, user, new Object[0]), (Supplier<Boolean>)((Supplier)() -> this.permissionManager.hasPermission(this.permission, user)));
    }
}

