/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.event;

import com.atlassian.analytics.api.annotations.EventName;
import com.atlassian.jira.event.AbstractEvent;

public class ExportEvent
extends AbstractEvent {
    private final String key;
    private final String delimiter;

    public ExportEvent(String key) {
        this.key = key;
        this.delimiter = "";
    }

    public ExportEvent(String key, String delimiter) {
        this.key = key;
        this.delimiter = delimiter;
    }

    public String getKey() {
        return this.key;
    }

    public String getDelimiter() {
        return this.delimiter;
    }

    @EventName
    public String calculateEventName() {
        return "jira.export." + this.getKey();
    }

    public static Builder builder() {
        return new Builder();
    }

    public static class Builder {
        private static final String ALL_FIELDS_KEY = "searchrequest-csv-all-fields";
        private static final String CURRENT_FIELDS_KEY = "searchrequest-csv-current-fields";
        private String key;
        private String delimiter;

        private Builder() {
        }

        public Builder withKey(String key) {
            this.key = key;
            return this;
        }

        public Builder withDelimiter(String delimiter) {
            this.delimiter = delimiter;
            return this;
        }

        public ExportEvent build() {
            if (this.key == null) {
                throw new IllegalArgumentException();
            }
            if (this.delimiter != null && (this.key.equals(ALL_FIELDS_KEY) || this.key.equals(CURRENT_FIELDS_KEY))) {
                return new ExportEvent(this.key, this.delimiter);
            }
            return new ExportEvent(this.key);
        }
    }
}

