/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.imports.project.customfield;

import com.atlassian.jira.imports.project.customfield.ExternalCustomFieldValue;
import com.atlassian.jira.imports.project.customfield.ProjectCustomFieldImporter;
import com.atlassian.jira.imports.project.mapper.ProjectImportMapper;
import com.atlassian.jira.issue.fields.config.FieldConfig;
import com.atlassian.jira.security.groups.GroupManager;
import com.atlassian.jira.util.I18nHelper;
import com.atlassian.jira.util.MessageSet;
import com.atlassian.jira.util.MessageSetImpl;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GroupCustomFieldImporter
implements ProjectCustomFieldImporter {
    private static final Logger log = LoggerFactory.getLogger(GroupCustomFieldImporter.class);
    private final GroupManager groupManager;

    public GroupCustomFieldImporter(GroupManager groupManager) {
        this.groupManager = groupManager;
    }

    @Override
    public MessageSet canMapImportValue(ProjectImportMapper projectImportMapper, ExternalCustomFieldValue customFieldValue, FieldConfig fieldConfig, I18nHelper i18n) {
        MessageSetImpl messageSet = new MessageSetImpl();
        String groupname = customFieldValue.getValue();
        if (groupname != null && groupname.length() > 0) {
            projectImportMapper.getGroupMapper().flagValueAsRequired(groupname);
            if (!this.groupManager.groupExists(groupname)) {
                messageSet.addErrorMessage(i18n.getText("admin.errors.project.import.group.validation.does.not.exist", groupname));
                messageSet.addErrorMessageInEnglish("The group '" + groupname + "' is required for the import but does not exist in the current JIRA instance.");
            }
        }
        return messageSet;
    }

    @Override
    public ProjectCustomFieldImporter.MappedCustomFieldValue getMappedImportValue(ProjectImportMapper projectImportMapper, ExternalCustomFieldValue customFieldValue, FieldConfig fieldConfig) {
        return new ProjectCustomFieldImporter.MappedCustomFieldValue(customFieldValue.getValue());
    }
}

