/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.project.template;

import com.atlassian.annotations.PublicApi;
import com.atlassian.jira.project.template.ProjectTemplateKey;
import com.atlassian.jira.project.template.hook.AddProjectHook;
import com.atlassian.jira.project.template.hook.AddProjectModule;
import com.atlassian.jira.project.template.hook.EmptyAddProjectHook;
import com.atlassian.jira.project.type.ProjectTypeKey;
import javax.annotation.Nonnull;
import org.apache.commons.lang3.StringUtils;

@PublicApi
public class ProjectTemplate
implements Comparable<ProjectTemplate> {
    private final ProjectTemplateKey key;
    private final ProjectTypeKey projectTypeKey;
    private final int weight;
    private final String name;
    private final String description;
    private final String longDescriptionContent;
    private final String iconUrl;
    private final String backgroundIconUrl;
    private final AddProjectModule addProjectModule;
    private final String infoSoyPath;

    public ProjectTemplate(ProjectTemplateKey key, ProjectTypeKey projectTypeKey, int weight, String name, String description, String longDescriptionContent, String iconUrl, String backgroundIconUrl, AddProjectModule addProjectModule, String infoSoyPath) {
        this.key = key;
        this.projectTypeKey = projectTypeKey;
        this.weight = weight;
        this.name = StringUtils.defaultString((String)name);
        this.description = StringUtils.defaultString((String)description);
        this.longDescriptionContent = StringUtils.defaultString((String)longDescriptionContent);
        this.iconUrl = StringUtils.defaultString((String)iconUrl);
        this.backgroundIconUrl = StringUtils.defaultString((String)backgroundIconUrl);
        this.addProjectModule = addProjectModule;
        this.infoSoyPath = infoSoyPath;
    }

    public ProjectTemplateKey getKey() {
        return this.key;
    }

    public ProjectTypeKey getProjectTypeKey() {
        return this.projectTypeKey;
    }

    public int getWeight() {
        return this.weight;
    }

    public String getName() {
        return this.name;
    }

    public String getDescription() {
        return this.description;
    }

    public String getLongDescriptionContent() {
        return this.longDescriptionContent;
    }

    public String getIconUrl() {
        return this.iconUrl;
    }

    public String getBackgroundIconUrl() {
        return this.backgroundIconUrl;
    }

    public Boolean getCreateProject() {
        return this.addProjectModule != null;
    }

    public Boolean isHasCreateHook() {
        return this.getCreateProject() != false && this.addProjectModule.hasProjectCreateHook();
    }

    @Nonnull
    public AddProjectHook getAddProjectHook() {
        if (!this.isHasCreateHook().booleanValue()) {
            return new EmptyAddProjectHook();
        }
        return this.addProjectModule.addProjectHook();
    }

    public boolean hasAddProjectModule() {
        return this.addProjectModule != null;
    }

    public AddProjectModule addProjectModule() {
        return this.addProjectModule;
    }

    public String getInfoSoyPath() {
        return this.infoSoyPath;
    }

    @Override
    public int compareTo(ProjectTemplate that) {
        int difference = this.weight - that.weight;
        if (difference == 0) {
            return this.name.compareTo(that.name);
        }
        return difference;
    }
}

