/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.util;

import com.atlassian.annotations.PublicApi;
import com.atlassian.jira.util.JiraUrlCodec;
import com.atlassian.jira.util.dbc.Assertions;
import com.google.common.collect.Lists;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.jcip.annotations.NotThreadSafe;
import org.apache.commons.lang.ArrayUtils;
import org.apache.commons.lang.StringUtils;

@NotThreadSafe
@PublicApi
public final class UrlBuilder {
    private static final char PATH_QUERY_SEPARATOR_CHAR = '?';
    private static final char PATH_SEPARATOR_CHAR = '/';
    private static final String PATH_SEPARATOR = String.valueOf('/');
    private final StringBuilder pathBuilder;
    private final StringBuilder anchorBuilder;
    private final StringBuilder queryBuilder;
    private final String encoding;
    private boolean querySnippet;

    public UrlBuilder(boolean querySnippet) {
        this("", querySnippet);
    }

    public UrlBuilder(UrlBuilder source) {
        Assertions.notNull("source", source);
        this.pathBuilder = new StringBuilder(source.pathBuilder);
        this.queryBuilder = new StringBuilder(source.queryBuilder);
        this.anchorBuilder = new StringBuilder(source.anchorBuilder);
        this.encoding = source.encoding;
        this.querySnippet = source.querySnippet;
    }

    public UrlBuilder(String urlFragment) {
        this(urlFragment, null, false);
    }

    @Nonnull
    public static URL createURL(String urlString) {
        try {
            return new URL(urlString);
        }
        catch (MalformedURLException e) {
            throw new IllegalArgumentException("The provided string is not valid URL: '" + urlString + "'", e);
        }
    }

    public UrlBuilder(String urlFragment, boolean querySnippet) {
        this(urlFragment, null, querySnippet);
    }

    public UrlBuilder(String urlFragment, @Nullable String encoding, boolean querySnippet) {
        Assertions.notNull("urlFragment", urlFragment);
        if (querySnippet) {
            this.pathBuilder = new StringBuilder();
            this.queryBuilder = new StringBuilder(urlFragment);
        } else {
            PathQueryHolder holder = UrlBuilder.parseBaseUrl(urlFragment);
            this.pathBuilder = new StringBuilder(holder.path);
            this.queryBuilder = new StringBuilder(holder.query);
        }
        this.anchorBuilder = new StringBuilder();
        this.encoding = encoding;
        this.querySnippet = querySnippet;
    }

    public UrlBuilder addPathUnsafe(String path) {
        Assertions.notBlank("path", path);
        boolean empty = this.pathBuilder.length() == 0;
        boolean urlEndsWithSlash = !empty && this.pathBuilder.charAt(this.pathBuilder.length() - 1) == '/';
        boolean pathStartsWithSlash = path.startsWith(PATH_SEPARATOR);
        if (!(empty || urlEndsWithSlash || pathStartsWithSlash)) {
            this.pathBuilder.append(PATH_SEPARATOR);
        } else if (urlEndsWithSlash && pathStartsWithSlash) {
            path = path.substring(1);
        }
        this.pathBuilder.append(path);
        return this;
    }

    public UrlBuilder addPath(String path) {
        boolean pathEndsWithSlash;
        Assertions.notBlank("path", path);
        String safePath = this.encode(StringUtils.strip((String)path, (String)"/"));
        boolean bl = pathEndsWithSlash = path.charAt(path.length() - 1) == '/';
        if (pathEndsWithSlash) {
            safePath = safePath + '/';
        }
        return this.addPathUnsafe(safePath);
    }

    public UrlBuilder addPaths(String paths) {
        boolean pathEndsWithSlash;
        Assertions.notBlank("paths", paths);
        String[] pathComponents = StringUtils.split((String)paths, (char)'/');
        ArrayList safePathComponents = Lists.newArrayListWithExpectedSize((int)pathComponents.length);
        for (String singlePath : pathComponents) {
            safePathComponents.add(this.encode(singlePath));
        }
        String safePaths = StringUtils.join((Collection)safePathComponents, (char)'/');
        boolean bl = pathEndsWithSlash = paths.charAt(paths.length() - 1) == '/';
        if (pathEndsWithSlash) {
            safePaths = safePaths + '/';
        }
        return this.addPathUnsafe(safePaths);
    }

    public UrlBuilder addParameterUnsafe(String name, String value) {
        Assertions.notBlank("name", name);
        this.addParameterSeparator();
        this.queryBuilder.append(name).append('=').append(value);
        return this;
    }

    public UrlBuilder addParameter(String name, String value) {
        Assertions.notBlank("name", name);
        String safeName = this.encode(name);
        String safeValue = value == null ? "" : this.encode(value);
        this.addParameterUnsafe(safeName, safeValue);
        return this;
    }

    public UrlBuilder addParameter(String name, Object value) {
        return this.addParameter(name, value == null ? null : value.toString());
    }

    public UrlBuilder addAnchor(String value) {
        Assertions.notBlank("value", value);
        String safeValue = this.encode(value);
        this.anchorBuilder.append("#").append(safeValue);
        return this;
    }

    public UrlBuilder addParametersFromMap(Map<?, ?> params) {
        Assertions.notNull("params", params);
        for (Map.Entry<?, ?> entry : params.entrySet()) {
            if (entry.getKey() == null || StringUtils.isBlank((String)entry.getKey().toString())) continue;
            this.addParameter(entry.getKey().toString(), entry.getValue());
        }
        return this;
    }

    public String asUrlString() {
        if (this.querySnippet) {
            return this.queryBuilder.length() == 0 ? "" : "&" + this.queryBuilder.toString() + this.anchorBuilder.toString();
        }
        if (this.queryBuilder.length() == 0) {
            return this.pathBuilder.toString() + this.anchorBuilder.toString();
        }
        return this.pathBuilder.toString() + "?" + this.queryBuilder.toString() + this.anchorBuilder.toString();
    }

    public URI asURI() {
        return URI.create(this.asUrlString());
    }

    public String toString() {
        return this.asUrlString();
    }

    private void addParameterSeparator() {
        if (this.queryBuilder.length() != 0) {
            this.queryBuilder.append("&");
        }
    }

    private String encode(String str) {
        if (str != null) {
            if (this.encoding == null) {
                return JiraUrlCodec.encode(str);
            }
            return JiraUrlCodec.encode(str, this.encoding);
        }
        return str;
    }

    private static PathQueryHolder parseBaseUrl(String url) {
        Assertions.notNull("url", url);
        Object[] tokens = StringUtils.splitPreserveAllTokens((String)url, (char)'?');
        switch (tokens.length) {
            case 0: {
                return new PathQueryHolder("", "");
            }
            case 1: {
                return new PathQueryHolder(tokens[0], "");
            }
            case 2: {
                return new PathQueryHolder(tokens[0], tokens[1]);
            }
        }
        return new PathQueryHolder(tokens[0], StringUtils.join((Object[])ArrayUtils.remove((Object[])tokens, (int)0), (char)'?'));
    }

    private static class PathQueryHolder {
        private final String path;
        private final String query;

        private PathQueryHolder(String path, String query) {
            this.path = path;
            this.query = query;
        }
    }
}

