/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.avatar;

import com.atlassian.annotations.ExperimentalApi;
import com.atlassian.annotations.Internal;
import com.atlassian.jira.avatar.Avatar;
import com.atlassian.jira.avatar.OriginalAvatarFormatPolicy;
import com.atlassian.jira.avatar.PngAvatarFormatPolicy;
import com.atlassian.jira.io.ResourceData;
import java.io.IOException;
import java.io.InputStream;

@ExperimentalApi
public abstract class AvatarFormatPolicy {
    public static AvatarFormatPolicy createOriginalDataPolicy() {
        return new OriginalAvatarFormatPolicy();
    }

    public static PngAvatarFormatPolicyBuilder createPngFormatPolicy() {
        return new PngAvatarFormatPolicyBuilder();
    }

    @Internal
    abstract ResourceData getData(Avatar var1, InputStreamSupplier var2, InputStreamSupplier var3) throws IOException;

    @Internal
    static interface InputStreamSupplier {
        public InputStream get() throws IOException;
    }

    public static class PngAvatarFormatPolicyBuilder {
        private PngAvatarFormatPolicyBuilder() {
        }

        public AvatarFormatPolicy withRejectingFallbackStrategy() {
            return new PngAvatarFormatPolicy(originalData -> {
                throw new IllegalArgumentException("Strictly requested PNG avatar data, but the avatar is of different type and cannot be transcoded");
            });
        }

        public AvatarFormatPolicy withFallingBackToOriginalDataStrategy() {
            return new PngAvatarFormatPolicy(originalData -> originalData);
        }
    }
}

