/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.query.clause;

import com.atlassian.fugue.Effect;
import com.atlassian.fugue.Option;
import com.atlassian.jira.util.dbc.Assertions;
import com.atlassian.query.clause.Clause;
import com.atlassian.query.clause.ClauseVisitor;
import com.atlassian.query.clause.Property;
import com.atlassian.query.clause.TerminalClause;
import com.atlassian.query.operand.MultiValueOperand;
import com.atlassian.query.operand.Operand;
import com.atlassian.query.operand.SingleValueOperand;
import com.atlassian.query.operator.Operator;
import java.util.Collections;
import java.util.List;

public class TerminalClauseImpl
implements TerminalClause {
    private final String name;
    private final Operator operator;
    private final Operand operand;
    private final Option<Property> property;

    public TerminalClauseImpl(String name, Operator operator, String operand) {
        this(name, operator, new SingleValueOperand(operand), (Option<Property>)Option.none());
    }

    public TerminalClauseImpl(String name, Operator operator, long operand) {
        this(name, operator, new SingleValueOperand(operand), (Option<Property>)Option.none());
    }

    public TerminalClauseImpl(String name, Operator operator, Operand operand) {
        this(name, operator, operand, (Option<Property>)Option.none());
    }

    public TerminalClauseImpl(String name, Operator operator, Operand operand, Option<Property> property) {
        this.operator = Assertions.notNull("operator", operator);
        this.operand = Assertions.notNull("operand", operand);
        this.name = Assertions.notNull("name", name);
        this.property = Assertions.notNull("property", property);
    }

    public TerminalClauseImpl(String name, String ... values) {
        Assertions.notNull("values", values);
        Assertions.not("values is empty", values.length == 0);
        this.name = Assertions.notNull("name", name);
        if (values.length == 1) {
            this.operator = Operator.EQUALS;
            this.operand = new SingleValueOperand(values[0]);
        } else {
            this.operator = Operator.IN;
            this.operand = new MultiValueOperand(values);
        }
        this.property = Option.none();
    }

    public TerminalClauseImpl(String name, Long ... values) {
        Assertions.notNull("values", values);
        Assertions.not("values", values.length == 0);
        this.name = Assertions.notNull("name", name);
        if (values.length == 1) {
            this.operator = Operator.EQUALS;
            this.operand = new SingleValueOperand(values[0]);
        } else {
            this.operator = Operator.IN;
            this.operand = new MultiValueOperand(values);
        }
        this.property = Option.none();
    }

    @Override
    public Operand getOperand() {
        return this.operand;
    }

    @Override
    public Operator getOperator() {
        return this.operator;
    }

    @Override
    public Option<Property> getProperty() {
        return this.property;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public List<Clause> getClauses() {
        return Collections.emptyList();
    }

    @Override
    public <R> R accept(ClauseVisitor<R> visitor) {
        return visitor.visit(this);
    }

    @Override
    public String toString() {
        final StringBuilder sb = new StringBuilder("{").append(this.getName());
        this.property.foreach((Effect)new Effect<Property>(){

            public void apply(Property property) {
                sb.append(property.toString());
            }
        });
        sb.append(" ");
        sb.append(this.operator.getDisplayString());
        sb.append(" ");
        sb.append(this.operand.getDisplayString()).append("}");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        TerminalClauseImpl that = (TerminalClauseImpl)o;
        if (!this.name.equals(that.name)) {
            return false;
        }
        if (!this.operand.equals(that.operand)) {
            return false;
        }
        if (this.operator != that.operator) {
            return false;
        }
        return this.property.equals(that.property);
    }

    public int hashCode() {
        int result = this.operand.hashCode();
        result = 31 * result + this.operator.hashCode();
        result = 31 * result + this.name.hashCode();
        result = 31 * result + this.property.hashCode();
        return result;
    }
}

