/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.util;

import com.atlassian.jira.component.ComponentAccessor;
import com.atlassian.jira.datetime.DateTimeFormatterFactory;
import com.atlassian.jira.datetime.DateTimeStyle;
import com.atlassian.jira.user.ApplicationUser;
import com.atlassian.jira.user.UserUtils;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.ofbiz.core.entity.GenericValue;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ParameterUtils {
    private static final Logger log = LoggerFactory.getLogger(ParameterUtils.class);

    public static Date getDateParam(Map params, String s, Locale locale) throws DateTooEarlyException {
        String paramValue = ParameterUtils.getStringParam(params, s);
        return ParameterUtils.parseDate(paramValue, locale);
    }

    public static Date parseDate(String paramValue, Locale locale) {
        if (StringUtils.isBlank((String)paramValue)) {
            return null;
        }
        try {
            Date date;
            try {
                date = ComponentAccessor.getComponent(DateTimeFormatterFactory.class).formatter().withLocale(locale).withStyle(DateTimeStyle.DATE_PICKER).parse(paramValue);
            }
            catch (IllegalArgumentException e) {
                date = ComponentAccessor.getComponent(DateTimeFormatterFactory.class).formatter().withLocale(locale).withStyle(DateTimeStyle.DATE_TIME_PICKER).parse(paramValue);
            }
            if (date != null && date.getTime() < 0L) {
                throw new DateTooEarlyException();
            }
            return date;
        }
        catch (IllegalArgumentException e) {
            log.warn("Could not parse: " + paramValue + " into a date");
            return null;
        }
    }

    public static ApplicationUser getUserParam(Map params, String s) {
        String paramValue = ParameterUtils.getStringParam(params, s);
        if (StringUtils.isBlank((String)paramValue)) {
            return null;
        }
        return UserUtils.getUser(paramValue);
    }

    public static List getListParam(Map params, String key) {
        String[] oArray;
        Object o = params.get(key);
        if (o instanceof String[] && (oArray = (String[])o).length > 0) {
            ArrayList<String> oList = new ArrayList<String>();
            for (String s : oArray) {
                if (StringUtils.isBlank((String)s)) continue;
                if (s.equalsIgnoreCase("-1")) {
                    oList.add(null);
                    continue;
                }
                oList.add(s);
            }
            return oList;
        }
        return null;
    }

    public static List getListParamKeepMinusOnes(Map params, String key) {
        Object o = params.get(key);
        if (o instanceof String[]) {
            Object[] oArray = (String[])o;
            if (oArray.length > 0) {
                return Lists.newArrayList((Object[])oArray);
            }
        } else if (o instanceof String) {
            return Lists.newArrayList((Object[])new Object[]{o});
        }
        return null;
    }

    public static List<Long> makeListLong(List<String> list) {
        ArrayList<Long> newList = null;
        if (list != null) {
            newList = new ArrayList<Long>(list.size());
            for (String item : list) {
                if (item == null) {
                    newList.add(null);
                    continue;
                }
                try {
                    newList.add(new Long(item));
                }
                catch (NumberFormatException e) {
                    log.warn("Could not convert to long: " + item);
                }
            }
        }
        return newList;
    }

    public static String getStringParam(Map params, String key) {
        Object o = params.get(key);
        if (o instanceof String) {
            return (String)o;
        }
        if (o instanceof String[]) {
            return ((String[])o)[0];
        }
        if (o instanceof Collection) {
            return (String)((Collection)o).iterator().next();
        }
        if (o == null) {
            return null;
        }
        return o.toString();
    }

    public static String[] getStringArrayParam(Map params, String paramName) {
        Object o = params.get(paramName);
        if (o instanceof String) {
            return new String[]{(String)o};
        }
        if (o instanceof String[]) {
            return (String[])o;
        }
        if (o instanceof Collection) {
            Collection c = (Collection)o;
            String[] sa = new String[c.size()];
            int i = 0;
            for (Object obj : c) {
                sa[i++] = obj == null ? null : String.valueOf(obj);
            }
            return sa;
        }
        if (o == null) {
            return null;
        }
        return new String[]{o.toString()};
    }

    public static String getStringParam(Map params, String targetKey, String targetValue, String desiredKey) {
        Object targetO = params.get(targetKey);
        Object desiredO = params.get(desiredKey);
        if (desiredO instanceof String) {
            return (String)desiredO;
        }
        if (targetO instanceof String[] && desiredO instanceof String[]) {
            for (int i = 0; i < ((String[])targetO).length; ++i) {
                if (!((String[])targetO)[i].equals(targetValue)) continue;
                return ((String[])desiredO)[i];
            }
            return ((String[])desiredO)[0];
        }
        if (desiredO == null) {
            return null;
        }
        return desiredO.toString();
    }

    public static boolean paramContains(Map params, String key, String value) {
        if (ParameterUtils.getStringParam(params, key, value, key) != null) {
            return ParameterUtils.getStringParam(params, key, value, key).equals(value);
        }
        return false;
    }

    public static Long getLongParam(Map params, String key) {
        String s = ParameterUtils.getStringParam(params, key);
        if (StringUtils.isBlank((String)s)) {
            return null;
        }
        try {
            return new Long(s);
        }
        catch (NumberFormatException nfe) {
            log.warn("NumberFormatException looking for param: " + key);
            return null;
        }
    }

    public static int getIntParam(Map mapOfParameters, String paramName, int defaultValue) {
        String s = ParameterUtils.getStringParam(mapOfParameters, paramName);
        if (StringUtils.isBlank((String)s)) {
            return defaultValue;
        }
        try {
            return Integer.valueOf(s);
        }
        catch (NumberFormatException nfe) {
            return defaultValue;
        }
    }

    public static boolean getBooleanParam(Map mapOfParameters, String paramName) {
        String s = ParameterUtils.getStringParam(mapOfParameters, paramName);
        return Boolean.valueOf(s);
    }

    public static Double getDoubleParam(Map params, String key) {
        String s = ParameterUtils.getStringParam(params, key);
        if (StringUtils.isBlank((String)s)) {
            return null;
        }
        try {
            return new Double(s);
        }
        catch (NumberFormatException nfe) {
            log.warn("NumberFormatException looking for param: " + key);
            return null;
        }
    }

    private static Object swapNull(Object o) {
        if (o == null) {
            return "-1";
        }
        return o;
    }

    public static Collection swapNulls(Collection col) {
        if (col == null) {
            return null;
        }
        ArrayList<Object> result = new ArrayList<Object>(col.size());
        for (Object aCol : col) {
            result.add(ParameterUtils.swapNull(aCol));
        }
        return result;
    }

    public static List<Long> getLongListFromStringArray(String[] ar) {
        if (ar == null || ar.length == 0) {
            return Collections.emptyList();
        }
        ArrayList<Long> result = new ArrayList<Long>(ar.length);
        for (String anAr : ar) {
            if (StringUtils.isBlank((String)anAr)) continue;
            result.add(new Long(anAr));
        }
        return result;
    }

    public static List<String> getListFromStringArray(String[] ar) {
        if (ar == null || ar.length == 0) {
            return Collections.emptyList();
        }
        ArrayList<String> result = new ArrayList<String>(ar.length);
        for (String anAr : ar) {
            if (StringUtils.isBlank((String)anAr)) continue;
            result.add(anAr);
        }
        return result;
    }

    public static String[] getStringArrayFromList(Collection entities) {
        String[] ar = new String[entities.size()];
        int i = 0;
        for (GenericValue genericValue : entities) {
            ar[i] = genericValue.getString("id");
            ++i;
        }
        return ar;
    }

    public static String makeCommaSeparated(Long[] longs) {
        StringBuilder result = new StringBuilder();
        for (int i = 0; i < longs.length; ++i) {
            result.append(longs[i]);
            if (i >= longs.length - 1) continue;
            result.append(",");
        }
        return result.toString();
    }

    public static class DateTooEarlyException
    extends RuntimeException {
        public DateTooEarlyException() {
        }

        public DateTooEarlyException(String message) {
            super(message);
        }
    }
}

