/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.jql.query;

import com.atlassian.jira.issue.customfields.converters.DoubleConverter;
import com.atlassian.jira.jql.operand.QueryLiteral;
import com.atlassian.jira.util.dbc.Assertions;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;

abstract class AbstractNumberOperatorQueryFactory {
    private final DoubleConverter doubleConverter;

    public AbstractNumberOperatorQueryFactory(DoubleConverter doubleConverter) {
        this.doubleConverter = Assertions.notNull("doubleConverter", doubleConverter);
    }

    List<Double> getIndexValues(List<QueryLiteral> rawValues) {
        ArrayList values = Lists.newArrayListWithCapacity((int)rawValues.size());
        for (QueryLiteral rawValue : rawValues) {
            if (rawValue.isEmpty()) {
                values.add(null);
                continue;
            }
            Double indexValue = this.doubleConverter.getDouble(rawValue.asString());
            if (indexValue == null) continue;
            values.add(indexValue);
        }
        return values;
    }
}

