/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.bc;

import com.atlassian.annotations.PublicApi;
import com.atlassian.jira.bc.ServiceResult;
import com.atlassian.jira.util.ErrorCollection;
import com.atlassian.jira.util.SimpleWarningCollection;
import com.atlassian.jira.util.WarningCollection;
import com.atlassian.jira.util.dbc.Assertions;
import javax.annotation.Nonnull;

@PublicApi
public class ServiceResultImpl
implements ServiceResult {
    private final ErrorCollection errorCollection;
    private final WarningCollection warningCollection;

    public ServiceResultImpl(@Nonnull ErrorCollection errorCollection) {
        this(errorCollection, new SimpleWarningCollection());
    }

    public ServiceResultImpl(@Nonnull ErrorCollection errorCollection, @Nonnull WarningCollection warningCollection) {
        this.errorCollection = Assertions.notNull("errorCollection", errorCollection);
        this.warningCollection = Assertions.notNull("warningCollection", warningCollection);
    }

    @Override
    public boolean isValid() {
        return !this.errorCollection.hasAnyErrors();
    }

    @Override
    public ErrorCollection getErrorCollection() {
        return this.errorCollection;
    }

    @Override
    public WarningCollection getWarningCollection() {
        return this.warningCollection;
    }
}

