/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.board.model;

import com.atlassian.annotations.ExperimentalApi;
import com.atlassian.jira.board.Board;
import com.atlassian.jira.board.BoardId;
import com.atlassian.jira.board.model.BoardColumn;
import com.atlassian.jira.issue.Issue;
import com.atlassian.jira.issue.status.Status;
import com.atlassian.jira.user.ApplicationUser;
import com.atlassian.jira.util.dbc.Assertions;
import com.google.common.collect.ImmutableList;
import java.util.Collection;
import java.util.List;
import java.util.Objects;

@ExperimentalApi
public class BoardData {
    private final Board board;
    private final String jql;
    private final BoardId id;
    private final List<Issue> issues;
    private final List<Status> statuses;
    private final List<ApplicationUser> people;
    private final List<BoardColumn> columns;
    private final int maxResults;
    private final int total;

    private BoardData(Board board, String jql, BoardId id, List<Issue> issues, List<Status> statuses, List<ApplicationUser> people, List<BoardColumn> columns, int maxResults, int total) {
        this.board = Assertions.notNull(board);
        this.jql = Assertions.notNull(jql);
        this.id = Assertions.notNull(id);
        this.issues = ImmutableList.copyOf((Collection)Assertions.notNull(issues));
        this.statuses = ImmutableList.copyOf((Collection)Assertions.notNull(statuses));
        this.people = ImmutableList.copyOf((Collection)Assertions.notNull(people));
        this.columns = ImmutableList.copyOf((Collection)Assertions.notNull(columns));
        this.maxResults = maxResults;
        this.total = total;
    }

    public Board getBoard() {
        return this.board;
    }

    public String getJql() {
        return this.jql;
    }

    public BoardId getId() {
        return this.id;
    }

    public List<Issue> getIssues() {
        return this.issues;
    }

    public List<Status> getStatuses() {
        return this.statuses;
    }

    public List<ApplicationUser> getPeople() {
        return this.people;
    }

    public List<BoardColumn> getColumns() {
        return this.columns;
    }

    public int getMaxResults() {
        return this.maxResults;
    }

    public int getTotal() {
        return this.total;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        BoardData boardData = (BoardData)o;
        return this.maxResults == boardData.maxResults && this.total == boardData.total && Objects.equals(this.board, boardData.board) && Objects.equals(this.jql, boardData.jql) && Objects.equals(this.id, boardData.id) && Objects.equals(this.issues, boardData.issues) && Objects.equals(this.statuses, boardData.statuses) && Objects.equals(this.people, boardData.people) && Objects.equals(this.columns, boardData.columns);
    }

    public int hashCode() {
        return Objects.hash(this.board, this.jql, this.id, this.issues, this.statuses, this.people, this.columns, this.maxResults, this.total);
    }

    public String toString() {
        return "BoardData{board=" + this.board + ", jql='" + this.jql + '\'' + ", id=" + this.id + ", issues=" + this.issues + ", statuses=" + this.statuses + ", people=" + this.people + ", columns=" + this.columns + ", maxResults=" + this.maxResults + ", total=" + this.total + '}';
    }

    public static class Builder {
        private Board board;
        private String jql;
        private BoardId id;
        private List<Issue> issues;
        private List<Status> statuses;
        private List<ApplicationUser> people;
        private List<BoardColumn> columns;
        private int maxResults;
        private int total;

        public Builder board(Board board) {
            this.board = board;
            return this;
        }

        public Builder jql(String jql) {
            this.jql = jql;
            return this;
        }

        public Builder id(BoardId boardId) {
            this.id = boardId;
            return this;
        }

        public Builder issues(List<Issue> issues) {
            this.issues = issues;
            return this;
        }

        public Builder statuses(List<Status> statuses) {
            this.statuses = statuses;
            return this;
        }

        public Builder people(List<ApplicationUser> people) {
            this.people = people;
            return this;
        }

        public Builder columns(List<BoardColumn> columns) {
            this.columns = columns;
            return this;
        }

        public Builder maxResults(int maxResults) {
            this.maxResults = maxResults;
            return this;
        }

        public Builder total(int total) {
            this.total = total;
            return this;
        }

        public BoardData build() {
            return new BoardData(this.board, this.jql, this.id, this.issues, this.statuses, this.people, this.columns, this.maxResults, this.total);
        }
    }
}

