/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.web.bean;

import com.atlassian.annotations.PublicApi;
import com.atlassian.jira.util.Function;
import com.atlassian.jira.util.collect.CollectionUtil;
import com.atlassian.jira.web.bean.PercentageGraphRow;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;

@PublicApi
public final class PercentageGraphModel {
    private final List<PercentageGraphRow> rows = new ArrayList<PercentageGraphRow>();
    private PercentageGraphRow lastRow;
    private long total = 0L;

    public void addRow(String color, long number, String description, String statuses) {
        this.lastRow = new PercentageGraphRow(color, number, description, statuses);
        this.rows.add(this.lastRow);
        this.total += number;
    }

    public void addRow(String color, long number, String description) {
        this.addRow(color, number, description, null);
    }

    public List<PercentageGraphRow> getRows() {
        return Collections.unmodifiableList(this.rows);
    }

    public int getPercentage(PercentageGraphRow row) {
        RowPercentageCalculator calculator = new RowPercentageCalculator(this.getTotal());
        if (this.lastRow.equals(row)) {
            return calculator.getLastPercentage(CollectionUtil.transformIterator(this.rows.iterator(), new Function<PercentageGraphRow, Long>(){

                @Override
                public Long get(PercentageGraphRow input) {
                    return input.getNumber();
                }
            }));
        }
        return calculator.getPercentage(row.getNumber());
    }

    public long getTotal() {
        return this.total;
    }

    public boolean isTotalZero() {
        return this.total == 0L;
    }

    static class RowPercentageCalculator {
        final float total;

        public RowPercentageCalculator(long total) {
            this.total = total;
        }

        public int getPercentage(long value) {
            return (int)((float)value / this.total * 100.0f);
        }

        public int getLastPercentage(Iterator<Long> numberIterator) {
            int cumulativePercentage = 0;
            while (numberIterator.hasNext()) {
                Long val = numberIterator.next();
                if (!numberIterator.hasNext()) continue;
                cumulativePercentage += this.getPercentage(val);
            }
            return 100 - cumulativePercentage;
        }
    }
}

