/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.service.util.handler;

import com.atlassian.annotations.Internal;
import com.atlassian.application.api.ApplicationKey;
import com.atlassian.core.util.FileSize;
import com.atlassian.jira.application.ApplicationRoleManager;
import com.atlassian.jira.bc.user.UserService;
import com.atlassian.jira.component.ComponentAccessor;
import com.atlassian.jira.config.properties.ApplicationProperties;
import com.atlassian.jira.exception.CreateException;
import com.atlassian.jira.exception.PermissionException;
import com.atlassian.jira.issue.AttachmentManager;
import com.atlassian.jira.issue.Issue;
import com.atlassian.jira.issue.IssueManager;
import com.atlassian.jira.issue.MutableIssue;
import com.atlassian.jira.issue.comments.Comment;
import com.atlassian.jira.issue.comments.CommentManager;
import com.atlassian.jira.issue.fields.TextFieldCharacterLengthValidator;
import com.atlassian.jira.issue.history.ChangeItemBean;
import com.atlassian.jira.permission.ProjectPermissions;
import com.atlassian.jira.security.PermissionManager;
import com.atlassian.jira.service.util.handler.MessageHandlerContext;
import com.atlassian.jira.service.util.handler.MessageHandlerExecutionMonitor;
import com.atlassian.jira.user.ApplicationUser;
import com.atlassian.jira.util.I18nHelper;
import com.atlassian.jira.web.util.AttachmentExceedsLimitException;
import com.atlassian.jira.web.util.AttachmentException;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.primitives.Ints;
import java.io.File;
import java.io.IOException;
import java.util.Set;
import javax.annotation.Nullable;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang.StringUtils;

@Internal
public class DefaultMessageHandlerContext
implements MessageHandlerContext {
    private final CommentManager commentManager;
    private final MessageHandlerExecutionMonitor monitor;
    private final IssueManager issueManager;
    private final AttachmentManager attachmentManager;
    private final TextFieldCharacterLengthValidator textFieldCharacterLengthValidator;
    private final PermissionManager permissionManager;
    private final ApplicationProperties applicationProperties;
    private final ApplicationRoleManager applicationRoleManager;
    private final UserService userService;

    public DefaultMessageHandlerContext(CommentManager commentManager, MessageHandlerExecutionMonitor monitor, IssueManager issueManager, AttachmentManager attachmentManager, TextFieldCharacterLengthValidator textFieldCharacterLengthValidator, PermissionManager permissionManager, ApplicationProperties applicationProperties, ApplicationRoleManager applicationRoleManager, UserService userService) {
        this.commentManager = commentManager;
        this.monitor = monitor;
        this.issueManager = issueManager;
        this.attachmentManager = attachmentManager;
        this.textFieldCharacterLengthValidator = textFieldCharacterLengthValidator;
        this.permissionManager = permissionManager;
        this.applicationProperties = applicationProperties;
        this.applicationRoleManager = applicationRoleManager;
        this.userService = userService;
    }

    @Deprecated
    public DefaultMessageHandlerContext(CommentManager commentManager, MessageHandlerExecutionMonitor monitor, IssueManager issueManager, AttachmentManager attachmentManager) {
        this(commentManager, monitor, issueManager, attachmentManager, ComponentAccessor.getComponent(TextFieldCharacterLengthValidator.class), ComponentAccessor.getPermissionManager(), ComponentAccessor.getApplicationProperties(), ComponentAccessor.getComponent(ApplicationRoleManager.class), ComponentAccessor.getComponent(UserService.class));
    }

    @Override
    public ApplicationUser createUser(String username, String password, String email, String fullname, Integer userEventType) throws PermissionException, CreateException {
        Set<ApplicationKey> applicationKeys = this.applicationRoleManager.getDefaultApplicationKeys();
        if (applicationKeys.isEmpty()) {
            this.monitor.error("There are no default applications configured, new users are not assigned to any groups therefore they can not create issues. Please visit Application Access page for more information.");
            return null;
        }
        if (!applicationKeys.stream().allMatch(roleKey -> this.applicationRoleManager.hasSeatsAvailable((ApplicationKey)roleKey, 1))) {
            this.monitor.error("One of default applications has exceeded its license limit, therefore new user can not be created. Please visit Application Access page for more information.");
            return null;
        }
        UserService.CreateUserRequest createUserRequest = UserService.CreateUserRequest.withUserDetails(null, username, password, email, fullname).sendNotification(userEventType != null).withApplicationAccess(applicationKeys).withEventUserEvent(userEventType == null ? 1 : userEventType).skipValidation();
        ApplicationUser user = this.userService.createUser(this.userService.validateCreateUser(createUserRequest));
        if (user != null) {
            this.monitor.info("Created user '" + user.getName() + ".");
        }
        return user;
    }

    @Override
    public Comment createComment(Issue issue, ApplicationUser author, String body, boolean dispatchEvent) {
        String commentBody;
        boolean bodyTooLong = this.textFieldCharacterLengthValidator.isTextTooLong(body);
        String string = commentBody = bodyTooLong ? this.trimToCharacterLimit(body) : body;
        if (bodyTooLong) {
            this.monitor.info("Comment body exceeds character limit as has been shortened. Original comment will be added as an attachment");
        }
        Comment comment = this.commentManager.create(issue, author, commentBody, dispatchEvent);
        this.monitor.info("Added comment '" + StringUtils.abbreviate((String)body, (int)20) + " 'by '" + this.getAuthorNameOrAnonymousIfNull(author) + "' to issue '" + issue.getKey() + "'");
        if (bodyTooLong) {
            this.addTextAsIssueAttachment(author, body, this.getI18nBean().getText("messagehandlercontext.issue.comment.extracted.from.mail.filename"), issue);
        }
        return comment;
    }

    private String getAuthorNameOrAnonymousIfNull(ApplicationUser author) {
        return author == null ? "anonymous" : author.getName();
    }

    @Override
    public Issue createIssue(@Nullable ApplicationUser reporter, Issue issue) throws CreateException {
        String originalDescription = issue.getDescription();
        String originalEnvironment = issue.getEnvironment();
        boolean descriptionTooLong = this.textFieldCharacterLengthValidator.isTextTooLong(originalDescription);
        boolean environmentTooLong = this.textFieldCharacterLengthValidator.isTextTooLong(originalEnvironment);
        if (descriptionTooLong || environmentTooLong) {
            MutableIssue issueCopy = ComponentAccessor.getIssueFactory().cloneIssue(issue);
            if (descriptionTooLong) {
                this.monitor.info("Issue description exceeds character limit as has been shortened. Original description will be added as an attachment.");
                issueCopy.setDescription(this.trimToCharacterLimit(originalDescription));
            }
            if (environmentTooLong) {
                this.monitor.info("Issue environment exceeds character limit as has been shortened. Original environment will be added as an attachment.");
                issueCopy.setEnvironment(this.trimToCharacterLimit(originalEnvironment));
            }
            Issue createdIssue = this.createIssueWithIssueManager(reporter, issueCopy);
            if (descriptionTooLong) {
                this.addTextAsIssueAttachment(reporter, originalDescription, this.getI18nBean().getText("messagehandlercontext.issue.description.extracted.from.mail.filename"), createdIssue);
            }
            if (environmentTooLong) {
                this.addTextAsIssueAttachment(reporter, originalEnvironment, this.getI18nBean().getText("messagehandlercontext.issue.environment.extracted.from.mail.filename"), createdIssue);
            }
            return createdIssue;
        }
        return this.createIssueWithIssueManager(reporter, issue);
    }

    @VisibleForTesting
    String trimToCharacterLimit(String text) {
        if (this.textFieldCharacterLengthValidator.isTextTooLong(text)) {
            int characterLimit = Ints.saturatedCast((long)this.textFieldCharacterLengthValidator.getMaximumNumberOfCharacters());
            if (characterLimit < 4) {
                return text.substring(0, characterLimit);
            }
            return StringUtils.abbreviate((String)text, (int)characterLimit);
        }
        return text;
    }

    @VisibleForTesting
    void addTextAsIssueAttachment(ApplicationUser author, String content, String attachmentFileName, Issue issue) {
        try {
            this.addAttachment(author, content, attachmentFileName, issue);
        }
        catch (AttachmentException ex) {
            this.addFailureAsMonitorInfo(attachmentFileName, issue, ex);
        }
        catch (PermissionException ex) {
            this.addFailureAsMonitorInfo(attachmentFileName, issue, ex);
        }
    }

    private void addFailureAsMonitorInfo(String attachmentFileName, Issue issue, Exception ex) {
        this.monitor.info(String.format("Failed to attach file '%s' as an attachment to issue '%s', reason: '%s'", attachmentFileName, issue.getKey(), ex.getMessage()), ex);
    }

    private void addAttachment(ApplicationUser author, String content, String attachmentFileName, Issue issue) throws PermissionException, AttachmentException {
        this.validateAddAttachment(author, issue);
        File attachmentFile = null;
        try {
            attachmentFile = this.createTempFile();
            FileUtils.writeStringToFile((File)attachmentFile, (String)content, (String)this.applicationProperties.getEncoding());
            this.createAttachment(attachmentFile, attachmentFileName, "text/plain", author, issue);
        }
        catch (IOException ex) {
            throw new AttachmentException("Failed to create attachment file", ex);
        }
        finally {
            if (attachmentFile != null) {
                attachmentFile.delete();
            }
        }
    }

    @VisibleForTesting
    File createTempFile() throws IOException {
        return File.createTempFile("tempattach", "dat");
    }

    @VisibleForTesting
    I18nHelper getI18nBean() {
        return ComponentAccessor.getJiraAuthenticationContext().getI18nHelper();
    }

    private Issue createIssueWithIssueManager(ApplicationUser reporter, Issue issue) throws CreateException {
        Issue issueObject = this.issueManager.createIssueObject(reporter, issue);
        this.monitor.info("Issue " + issueObject.getKey() + " created");
        return issueObject;
    }

    @Override
    public ChangeItemBean createAttachment(File file, String filename, String contentType, ApplicationUser author, Issue issue) throws AttachmentException {
        this.validateAttachmentLimitSize(file, filename);
        ChangeItemBean changeItemBean = this.attachmentManager.createAttachment(file, filename, contentType, author, issue);
        if (changeItemBean != null) {
            this.monitor.info("Added attachment to issue '" + issue.getKey() + "'");
        }
        return changeItemBean;
    }

    private void validateAddAttachment(ApplicationUser author, Issue issue) throws AttachmentException, PermissionException {
        if (!this.attachmentManager.attachmentsEnabled()) {
            throw new AttachmentException("Attachments are disabled");
        }
        if (this.hasNoPermissionToCreateAttachments(author, issue)) {
            throw new PermissionException(String.format("User '%s' has no permission to create attachments in project '%s'", this.getAuthorNameOrAnonymousIfNull(author), issue.getProjectObject().getKey()));
        }
    }

    private void validateAttachmentLimitSize(File file, String fileName) throws AttachmentException {
        long maxAttachmentSize = Long.parseLong(this.applicationProperties.getDefaultBackedString("webwork.multipart.maxSize"));
        if (file.length() > maxAttachmentSize) {
            String message = this.getI18nBean().getText("upload.too.big", fileName, FileSize.format((long)file.length()), FileSize.format((long)maxAttachmentSize));
            throw new AttachmentExceedsLimitException(message);
        }
    }

    private boolean hasNoPermissionToCreateAttachments(ApplicationUser author, Issue issue) {
        return !this.permissionManager.hasPermission(ProjectPermissions.CREATE_ATTACHMENTS, issue, author);
    }

    @Override
    public boolean isRealRun() {
        return true;
    }

    @Override
    public MessageHandlerExecutionMonitor getMonitor() {
        return this.monitor;
    }
}

