/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.issue.search;

import com.atlassian.jira.component.ComponentAccessor;
import com.atlassian.jira.issue.search.SearchContext;
import com.atlassian.jira.issue.search.SearchContextFactory;
import java.util.Collections;
import java.util.List;
import org.apache.commons.collections.ListUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SearchRequestUtils {
    private static final Logger log = LoggerFactory.getLogger(SearchRequestUtils.class);

    public static SearchContext getCombinedSearchContext(SearchContext baseSearchContext, SearchContext possibleContext) {
        if (baseSearchContext != null) {
            if (possibleContext != null) {
                List<String> combinedIssuetypes;
                List<Long> combinedProjects;
                if (baseSearchContext.isForAnyProjects()) {
                    combinedProjects = possibleContext.getProjectIds();
                } else {
                    combinedProjects = ListUtils.intersection(baseSearchContext.getProjectIds(), possibleContext.getProjectIds() != null ? possibleContext.getProjectIds() : Collections.EMPTY_LIST);
                    if (combinedProjects.isEmpty()) {
                        combinedProjects = baseSearchContext.getProjectIds();
                    }
                }
                if (baseSearchContext.isForAnyIssueTypes()) {
                    combinedIssuetypes = possibleContext.getIssueTypeIds();
                } else {
                    combinedIssuetypes = ListUtils.intersection(baseSearchContext.getIssueTypeIds(), possibleContext.getIssueTypeIds() != null ? possibleContext.getIssueTypeIds() : Collections.EMPTY_LIST);
                    if (combinedIssuetypes.isEmpty()) {
                        combinedIssuetypes = baseSearchContext.getIssueTypeIds();
                    }
                }
                SearchContextFactory searchContextFactory = ComponentAccessor.getComponent(SearchContextFactory.class);
                return searchContextFactory.create(null, combinedProjects, combinedIssuetypes);
            }
            SearchContextFactory searchContextFactory = ComponentAccessor.getComponent(SearchContextFactory.class);
            return searchContextFactory.create(baseSearchContext);
        }
        return null;
    }
}

