/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.notification.type;

import com.atlassian.annotations.PublicApi;

@PublicApi
public enum NotificationType {
    CURRENT_ASSIGNEE("Current_Assignee", "CurrentAssignee"),
    REPORTER("Current_Reporter", "Reporter"),
    CURRENT_USER("Remote_User", "CurrentUser"),
    PROJECT_LEAD("Project_Lead", "ProjectLead"),
    COMPONENT_LEAD("Component_Lead", "ComponentLead"),
    SINGLE_USER("Single_User", "User"),
    GROUP("Group_Dropdown", "Group"),
    PROJECT_ROLE("Project_Role", "ProjectRole"),
    SINGLE_EMAIL_ADDRESS("Single_Email_Address", "EmailAddress"),
    ALL_WATCHERS("All_Watchers", "AllWatchers"),
    USER_CUSTOM_FIELD_VALUE("User_Custom_Field_Value", "UserCustomField"),
    GROUP_CUSTOM_FIELD_VALUE("Group_Custom_Field_Value", "GroupCustomField");

    private final String dbCode;
    private final String restApiName;

    private NotificationType(String dbCode, String restApiName) {
        this.dbCode = dbCode;
        this.restApiName = restApiName;
    }

    public String dbCode() {
        return this.dbCode;
    }

    public String getRestApiName() {
        return this.restApiName;
    }

    public static NotificationType from(String dbCode) {
        for (NotificationType notificationType : NotificationType.values()) {
            if (!notificationType.dbCode().equals(dbCode)) continue;
            return notificationType;
        }
        throw new IllegalArgumentException("You have to provide a valid mapped string");
    }
}

