/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.issue.util;

public class AggregateTimeTrackingBean {
    public static final String AGG_TIMETRACKING = "atl.jira.timetracking.aggregate.bean.";
    private Long timeSpent;
    private Long originalEstimate;
    private Long remainingEstimate;
    private int subtaskCount = 0;
    private Long greastestSubTaskEstimate = null;

    public AggregateTimeTrackingBean(Long originalEstimate, Long remainingEstimate, Long timeSpent, int subtaskCount) {
        this.timeSpent = timeSpent;
        this.originalEstimate = originalEstimate;
        this.remainingEstimate = remainingEstimate;
        this.subtaskCount = subtaskCount;
    }

    public Long getTimeSpent() {
        return this.timeSpent;
    }

    public void setTimeSpent(Long timeSpent) {
        this.timeSpent = timeSpent;
    }

    public Long getOriginalEstimate() {
        return this.originalEstimate;
    }

    public void setOriginalEstimate(Long originalEstimate) {
        this.originalEstimate = originalEstimate;
    }

    public Long getRemainingEstimate() {
        return this.remainingEstimate;
    }

    public void setRemainingEstimate(Long remainingEstimate) {
        this.remainingEstimate = remainingEstimate;
    }

    public int getSubTaskCount() {
        return this.subtaskCount;
    }

    public void setSubTaskCount(int subtaskCount) {
        this.subtaskCount = subtaskCount;
    }

    public Long getGreastestSubTaskEstimate() {
        return this.greastestSubTaskEstimate;
    }

    public void setGreastestSubTaskEstimate(Long greastestSubTaskEstimate) {
        this.greastestSubTaskEstimate = greastestSubTaskEstimate;
    }

    public void bumpGreatestSubTaskEstimate(Long originalEstimate, Long remainingEstimate, Long timeSpent) {
        Long estimate = AggregateTimeTrackingBean.getTheGreaterOfEstimates(originalEstimate, remainingEstimate, timeSpent);
        if (estimate != null) {
            Long singleEstimate = this.getGreastestSubTaskEstimate();
            if (singleEstimate == null) {
                this.setGreastestSubTaskEstimate(estimate);
            } else if (estimate > singleEstimate) {
                this.setGreastestSubTaskEstimate(estimate);
            }
        }
    }

    public static Long getTheGreaterOfEstimates(Long originalEstimate, Long remainingEstimate, Long timeSpent) {
        Long totalTime = AggregateTimeTrackingBean.addAndPreserveNull(remainingEstimate, timeSpent);
        if (originalEstimate == null) {
            return totalTime;
        }
        return totalTime == null ? originalEstimate : new Long(Math.max(originalEstimate, totalTime));
    }

    public static Long addAndPreserveNull(Long estValue, Long origValue) {
        Long newValue = estValue != null ? (origValue == null ? estValue : new Long(estValue + origValue)) : origValue;
        return newValue;
    }
}

