/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.bc.project.component;

import com.atlassian.annotations.PublicApi;
import com.atlassian.jira.bc.project.component.ProjectComponent;
import com.atlassian.jira.component.ComponentAccessor;
import com.atlassian.jira.user.ApplicationUser;
import com.google.common.collect.Lists;
import com.opensymphony.util.TextUtils;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import org.ofbiz.core.entity.GenericValue;

@PublicApi
public class MutableProjectComponent
implements ProjectComponent {
    private Long id;
    private String name;
    private String lead;
    private String description;
    private Long projectId;
    private long assigneeType;
    private GenericValue genericValue;

    public MutableProjectComponent(Long id, String name, String description, String lead, long assigneeType, Long projectId) {
        this.id = id;
        this.setDescription(description);
        this.lead = lead;
        this.name = name;
        this.projectId = projectId;
        this.assigneeType = assigneeType;
    }

    public static MutableProjectComponent copy(ProjectComponent c) {
        MutableProjectComponent mutableProjectComponent = new MutableProjectComponent(c.getId(), c.getName(), c.getDescription(), c.getLead(), c.getAssigneeType(), c.getProjectId());
        mutableProjectComponent.setGenericValue(c.getGenericValue());
        return mutableProjectComponent;
    }

    public static Collection<MutableProjectComponent> copy(Collection<ProjectComponent> c) {
        if (c != null && !c.isEmpty()) {
            ArrayList copyList = Lists.newArrayListWithCapacity((int)c.size());
            for (ProjectComponent aC : c) {
                copyList.add(MutableProjectComponent.copy(aC));
            }
            return copyList;
        }
        return Collections.EMPTY_LIST;
    }

    @Override
    public Long getId() {
        return this.id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    @Override
    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = TextUtils.stringSet((String)description) ? description : null;
    }

    @Override
    public String getLead() {
        return this.lead;
    }

    @Override
    public ApplicationUser getComponentLead() {
        return ComponentAccessor.getUserManager().getUserByKey(this.getLead());
    }

    public void setLead(String lead) {
        this.lead = lead;
    }

    @Override
    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    @Override
    public Long getProjectId() {
        return this.projectId;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || !(o instanceof MutableProjectComponent)) {
            return false;
        }
        Long thatId = ((MutableProjectComponent)o).getId();
        return thatId != null && thatId.equals(this.id);
    }

    public int hashCode() {
        return this.id.hashCode();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("MutableProjectComponent { name='");
        sb.append(this.name);
        sb.append("', description='");
        sb.append(this.description == null ? "" : this.description);
        sb.append("'");
        sb.append(", lead='");
        sb.append(this.lead == null ? "" : this.lead);
        sb.append(", assigneeType='").append(this.assigneeType);
        sb.append("' }");
        return sb.toString();
    }

    public boolean equalsName(MutableProjectComponent component) {
        return this.getName().equalsIgnoreCase(component.getName());
    }

    @Override
    public long getAssigneeType() {
        return this.assigneeType;
    }

    public void setAssigneeType(long assigneeType) {
        this.assigneeType = assigneeType;
    }

    void setGenericValue(GenericValue genericValue) {
        this.genericValue = genericValue;
    }

    @Override
    public GenericValue getGenericValue() {
        return this.genericValue;
    }
}

