/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.service.services.file;

import com.atlassian.annotations.Internal;
import com.atlassian.configurable.ObjectConfigurationException;
import com.atlassian.event.api.EventListener;
import com.atlassian.jira.application.ApplicationRoleManager;
import com.atlassian.jira.component.ComponentAccessor;
import com.atlassian.jira.issue.fields.TextFieldCharacterLengthValidator;
import com.atlassian.jira.service.AbstractService;
import com.atlassian.jira.service.util.ServiceUtils;
import com.atlassian.jira.service.util.handler.DefaultMessageHandlerContext;
import com.atlassian.jira.service.util.handler.MessageHandler;
import com.atlassian.jira.service.util.handler.MessageHandlerContext;
import com.atlassian.jira.service.util.handler.MessageHandlerExecutionMonitor;
import com.atlassian.jira.service.util.handler.MessageHandlerFactory;
import com.atlassian.plugin.event.PluginEventManager;
import com.atlassian.plugin.event.events.PluginModuleDisabledEvent;
import com.opensymphony.module.propertyset.PropertySet;
import com.opensymphony.util.TextUtils;
import java.lang.ref.WeakReference;
import java.util.Arrays;
import java.util.Map;
import javax.annotation.Nullable;
import javax.mail.Message;
import javax.mail.MessagingException;
import org.apache.log4j.Logger;

@Internal
public abstract class AbstractMessageHandlingService
extends AbstractService {
    public static final String KEY_HANDLER = "handler";
    public static final String KEY_HANDLER_PARAMS = "handler.params";
    public static final int MAX_READ_MESSAGES_DRY_RUN = 10;
    private volatile MessageHandler handler = null;
    private volatile String handlerModuleDescriptorKey;
    private MessageHandlerContext context;
    private HandlerDisablementListener handlerDisablementListener;

    public synchronized void setContext(MessageHandlerContext context) {
        this.context = context;
    }

    private synchronized void setupHandlerEnablementMonitoringListener(String handlerModuleDescriptorKey) {
        this.cleanupListener();
        if (handlerModuleDescriptorKey == null) {
            return;
        }
        this.handlerDisablementListener = new HandlerDisablementListener(this, handlerModuleDescriptorKey);
        this.handlerDisablementListener.register();
    }

    private synchronized void cleanupListener() {
        if (this.handlerDisablementListener == null) {
            return;
        }
        this.handlerDisablementListener.unregister();
        this.handlerDisablementListener = null;
    }

    @Override
    public void destroy() {
        this.cleanupListener();
        super.destroy();
    }

    @Override
    public void init(PropertySet props) throws ObjectConfigurationException {
        super.init(props);
        if (props.getKeys().isEmpty()) {
            this.log.debug((Object)"init() called with empty PropertySet - that's apparently when the service is being added - we expect one more call to init() momentarily.");
            return;
        }
        this.cleanupListener();
        this.createAndInitializeMessageHandler();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void createAndInitializeMessageHandler() {
        block11: {
            String handlerClazz;
            MessageHandlerContext handlerContext = this.getContext();
            try {
                handlerClazz = this.getProperty(KEY_HANDLER);
            }
            catch (ObjectConfigurationException e) {
                handlerContext.getMonitor().error("You must specify a valid handler class for the " + this.getClass().getName() + " Service.");
                return;
            }
            try {
                if (TextUtils.stringSet((String)handlerClazz)) {
                    MessageHandlerFactory messageHandlerFactory = ComponentAccessor.getOSGiComponentInstanceOfType(MessageHandlerFactory.class);
                    if (messageHandlerFactory == null) {
                        handlerContext.getMonitor().error("Cannot get MessageHandlerFactory. Perhaps your JIRA Mail Plugin is disabled or missing?");
                        return;
                    }
                    this.log.debug((Object)"Instantiating message handler");
                    MessageHandler messageHandler = messageHandlerFactory.getHandler(handlerClazz);
                    if (messageHandler == null) {
                        handlerContext.getMonitor().error("Cannot instantiate message handler '" + handlerClazz + ". This service will not work until this problem is fixed.");
                        return;
                    }
                    try {
                        if (this.hasProperty(KEY_HANDLER_PARAMS)) {
                            Map<String, String> handlerParams = ServiceUtils.getParameterMap(this.getProperty(KEY_HANDLER_PARAMS));
                            messageHandler.init(handlerParams, this.getContext().getMonitor());
                        }
                        break block11;
                    }
                    finally {
                        this.handler = messageHandler;
                        this.handlerModuleDescriptorKey = ComponentAccessor.getOSGiComponentInstanceOfType(MessageHandlerFactory.class).getCorrespondingModuleDescriptorKey(handlerClazz);
                        this.setupHandlerEnablementMonitoringListener(this.handlerModuleDescriptorKey);
                    }
                }
                handlerContext.getMonitor().error("You must specify a valid handler class for the " + this.getClass().getName() + " Service.");
            }
            catch (Exception e) {
                handlerContext.getMonitor().error("Could not create handler '" + handlerClazz + "' - " + e, e);
            }
        }
    }

    private synchronized MessageHandlerContext getContext() {
        if (this.context == null) {
            this.context = new DefaultMessageHandlerContext(ComponentAccessor.getCommentManager(), new Log4jMessageHandlerExecutionMonitor(), ComponentAccessor.getIssueManager(), ComponentAccessor.getAttachmentManager(), ComponentAccessor.getComponent(TextFieldCharacterLengthValidator.class), ComponentAccessor.getPermissionManager(), ComponentAccessor.getApplicationProperties(), ComponentAccessor.getComponent(ApplicationRoleManager.class));
        }
        return this.context;
    }

    protected abstract void runImpl(MessageHandlerContext var1);

    @Override
    public void run() {
        if (this.handlerModuleDescriptorKey != null && !ComponentAccessor.getPluginAccessor().isPluginModuleEnabled(this.handlerModuleDescriptorKey)) {
            this.clearHandler();
        }
        this.runImpl(this.getContext());
    }

    public synchronized MessageHandler getHandler() {
        if (this.handler == null) {
            this.cleanupListener();
            this.createAndInitializeMessageHandler();
        }
        return this.handler;
    }

    private synchronized void clearHandler() {
        this.log.debug((Object)"Clearing message handler reference");
        this.handler = null;
        this.handlerModuleDescriptorKey = null;
    }

    protected abstract String addHandlerInfo(String var1);

    protected abstract Logger getLogger();

    protected final String asString(Message message) {
        if (message == null) {
            return null;
        }
        try {
            return String.format("From :%s, Subject: %s, Date: ", Arrays.toString(message.getFrom()), message.getSubject());
        }
        catch (MessagingException e) {
            return message.toString();
        }
    }

    private class Log4jMessageHandlerExecutionMonitor
    implements MessageHandlerExecutionMonitor {
        private Log4jMessageHandlerExecutionMonitor() {
        }

        @Override
        public void setNumMessages(int count) {
        }

        @Override
        public void error(String error) {
            AbstractMessageHandlingService.this.getLogger().error((Object)AbstractMessageHandlingService.this.addHandlerInfo(error));
        }

        @Override
        public void info(String info) {
            AbstractMessageHandlingService.this.getLogger().info((Object)AbstractMessageHandlingService.this.addHandlerInfo(info));
        }

        @Override
        public void info(String info, @Nullable Throwable e) {
            AbstractMessageHandlingService.this.getLogger().info((Object)AbstractMessageHandlingService.this.addHandlerInfo(info), e);
        }

        @Override
        public void error(String error, @Nullable Throwable e) {
            AbstractMessageHandlingService.this.getLogger().error((Object)AbstractMessageHandlingService.this.addHandlerInfo(error), e);
        }

        @Override
        public void warning(String warning) {
            AbstractMessageHandlingService.this.getLogger().warn((Object)AbstractMessageHandlingService.this.addHandlerInfo(warning));
        }

        @Override
        public void messageRejected(Message message, String reason) {
            if (AbstractMessageHandlingService.this.getLogger().isDebugEnabled()) {
                AbstractMessageHandlingService.this.getLogger().debug((Object)AbstractMessageHandlingService.this.addHandlerInfo(String.format("The message has been rejected (%s): %s", reason, AbstractMessageHandlingService.this.asString(message))));
            }
        }

        @Override
        public void nextMessage(Message message) {
        }

        @Override
        public void markMessageForDeletion(String reason) {
            AbstractMessageHandlingService.this.getLogger().debug((Object)AbstractMessageHandlingService.this.addHandlerInfo(reason));
        }

        @Override
        public void warning(String warning, @Nullable Throwable e) {
            AbstractMessageHandlingService.this.getLogger().warn((Object)AbstractMessageHandlingService.this.addHandlerInfo(warning), e);
        }
    }

    @Internal
    public static class HandlerDisablementListener {
        static final Logger log = Logger.getLogger(HandlerDisablementListener.class);
        private final WeakReference<AbstractMessageHandlingService> service;
        private final String moduleDescriptorKey;

        private HandlerDisablementListener(AbstractMessageHandlingService service, String moduleDescriptorKey) {
            this.moduleDescriptorKey = moduleDescriptorKey;
            this.service = new WeakReference<AbstractMessageHandlingService>(service);
        }

        private void cleanIfPossible() {
            if (this.service.get() == null) {
                this.unregister();
            }
        }

        private void unregister() {
            log.info((Object)("Unregistering disablement listener for module '" + this.moduleDescriptorKey + "'"));
            PluginEventManager pluginEventManager = ComponentAccessor.getPluginEventManager();
            if (pluginEventManager != null) {
                pluginEventManager.unregister((Object)this);
            }
        }

        private void register() {
            log.info((Object)("Registering disablement listener for module '" + this.moduleDescriptorKey + "'"));
            ComponentAccessor.getPluginEventManager().register((Object)this);
        }

        @EventListener
        public void onPluginModuleDisabled(PluginModuleDisabledEvent event) {
            this.cleanIfPossible();
            String completeKey = event.getModule().getCompleteKey();
            log.debug((Object)("Module has been disabled '" + completeKey + "'"));
            if (!this.moduleDescriptorKey.equals(completeKey)) {
                return;
            }
            log.info((Object)("Plugin Module '" + completeKey + "' defining the handler used by this service has been disabled. Clearing the reference to avoid resource leaks."));
            AbstractMessageHandlingService ref = (AbstractMessageHandlingService)this.service.get();
            if (ref != null) {
                ref.clearHandler();
            }
            this.unregister();
        }
    }
}

