/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.jql.query;

import com.atlassian.annotations.PublicApi;
import com.atlassian.jira.component.ComponentAccessor;
import com.atlassian.jira.issue.search.util.TextTermEscaper;
import com.atlassian.jira.jql.operand.QueryLiteral;
import com.atlassian.jira.jql.operator.OperatorClasses;
import com.atlassian.jira.jql.query.OperatorSpecificQueryFactory;
import com.atlassian.jira.jql.query.QueryFactoryResult;
import com.atlassian.jira.jql.query.TermQueryFactory;
import com.atlassian.query.lucene.parsing.LuceneQueryParserFactory;
import com.atlassian.query.operator.Operator;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.apache.lucene.queryParser.ParseException;
import org.apache.lucene.queryParser.QueryParser;
import org.apache.lucene.search.BooleanClause;
import org.apache.lucene.search.BooleanQuery;
import org.apache.lucene.search.Query;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@PublicApi
public class LikeQueryFactory
implements OperatorSpecificQueryFactory {
    private static final Logger log = LoggerFactory.getLogger(LikeQueryFactory.class);
    private final boolean usesMainIndex;

    public LikeQueryFactory() {
        this.usesMainIndex = true;
    }

    public LikeQueryFactory(boolean usesMainIndex) {
        this.usesMainIndex = usesMainIndex;
    }

    @Override
    public QueryFactoryResult createQueryForSingleValue(String fieldName, Operator operator, List<QueryLiteral> rawValues) {
        if (operator != Operator.LIKE && operator != Operator.NOT_LIKE) {
            if (log.isDebugEnabled()) {
                log.debug(String.format("Operator '%s' is not a LIKE operator.", operator.getDisplayString()));
            }
            return QueryFactoryResult.createFalseResult();
        }
        if (rawValues == null) {
            return QueryFactoryResult.createFalseResult();
        }
        return this.createResult(fieldName, rawValues, operator, this.usesMainIndex);
    }

    public QueryFactoryResult createResult(String fieldName, List<QueryLiteral> rawValues, Operator operator, boolean handleEmpty) {
        List<Query> queries = this.getQueries(fieldName, rawValues);
        if (queries == null || queries.isEmpty()) {
            return QueryFactoryResult.createFalseResult();
        }
        BooleanQuery fullQuery = new BooleanQuery();
        boolean hasEmpty = false;
        if (queries.size() == 1) {
            if (queries.get(0) == null && handleEmpty) {
                return this.createQueryForEmptyOperand(fieldName, operator);
            }
            fullQuery.add(queries.get(0), operator == Operator.NOT_LIKE ? BooleanClause.Occur.MUST_NOT : BooleanClause.Occur.MUST);
        } else {
            BooleanQuery subQuery = new BooleanQuery();
            for (Query query : queries) {
                if (query == null) {
                    hasEmpty = true;
                    continue;
                }
                subQuery.add(query, operator == Operator.NOT_LIKE ? BooleanClause.Occur.MUST_NOT : BooleanClause.Occur.SHOULD);
            }
            if (handleEmpty && hasEmpty) {
                subQuery.add(this.createQueryForEmptyOperand(fieldName, operator).getLuceneQuery(), operator == Operator.NOT_LIKE ? BooleanClause.Occur.MUST : BooleanClause.Occur.SHOULD);
            }
            fullQuery.add((Query)subQuery, BooleanClause.Occur.MUST);
        }
        if (handleEmpty && !hasEmpty) {
            fullQuery.add(TermQueryFactory.nonEmptyQuery(fieldName), BooleanClause.Occur.MUST);
            fullQuery.add(TermQueryFactory.visibilityQuery(fieldName), BooleanClause.Occur.MUST);
        }
        return new QueryFactoryResult((Query)fullQuery);
    }

    private List<Query> getQueries(String fieldName, List<QueryLiteral> rawValues) {
        QueryParser parser = this.getQueryParser(fieldName);
        parser.setDefaultOperator(QueryParser.Operator.AND);
        ArrayList queries = Lists.newArrayListWithCapacity((int)rawValues.size());
        for (QueryLiteral rawValue : rawValues) {
            Query query;
            if (rawValue.isEmpty()) {
                queries.add(null);
                continue;
            }
            if (StringUtils.isBlank((String)rawValue.asString())) continue;
            try {
                String value = this.getEscapedValueFromRawValues(rawValue);
                query = parser.parse(value);
            }
            catch (ParseException e) {
                if (log.isDebugEnabled()) {
                    log.debug(String.format("Unable to parse the text '%s' for field '%s'.", rawValue.asString(), fieldName));
                }
                return null;
            }
            catch (RuntimeException e) {
                if (log.isDebugEnabled()) {
                    log.debug(String.format("Unable to parse the text '%s' for field '%s'.", rawValue.asString(), fieldName));
                }
                return null;
            }
            queries.add(query);
        }
        return queries;
    }

    @Override
    public QueryFactoryResult createQueryForEmptyOperand(String fieldName, Operator operator) {
        if (operator == Operator.IS || operator == Operator.LIKE) {
            QueryFactoryResult result = new QueryFactoryResult(TermQueryFactory.nonEmptyQuery(fieldName), true);
            return QueryFactoryResult.wrapWithVisibilityQuery(fieldName, result);
        }
        if (operator == Operator.IS_NOT || operator == Operator.NOT_LIKE) {
            return new QueryFactoryResult(TermQueryFactory.nonEmptyQuery(fieldName));
        }
        if (log.isDebugEnabled()) {
            log.debug(String.format("Create query for empty operand was called with operator '%s', this only handles '=', '!=', 'is' and 'not is'.", operator.getDisplayString()));
        }
        return QueryFactoryResult.createFalseResult();
    }

    private String getEscapedValueFromRawValues(QueryLiteral rawValue) {
        if (rawValue.isEmpty()) {
            return null;
        }
        String value = rawValue.asString();
        return TextTermEscaper.escape(value);
    }

    @Override
    public QueryFactoryResult createQueryForMultipleValues(String fieldName, Operator operator, List<QueryLiteral> rawValues) {
        if (log.isDebugEnabled()) {
            log.debug("LIKE clauses do not support multi value operands.");
        }
        return QueryFactoryResult.createFalseResult();
    }

    @Override
    public boolean handlesOperator(Operator operator) {
        return OperatorClasses.TEXT_OPERATORS.contains((Object)operator);
    }

    @VisibleForTesting
    QueryParser getQueryParser(String fieldName) {
        return ComponentAccessor.getComponent(LuceneQueryParserFactory.class).createParserFor(fieldName);
    }
}

